package cn.smarthse.modules.health.entity.base.wmbase;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

@Table(name = "wm_content_type")
public class WmContentType implements Serializable {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 内容名称
     */
    private String content;

    /**
     * 内容类型(1-语句内容,2-警示线,3-告知卡内容,4公告栏内容)
     */
    private Byte type;

    /**
     * 企业ID
     */
    private Long cid;
   
    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;
    
    /**
     * 1-正常,0-已删除
     */
    @Column(name = "is_valid")
    private Boolean isValid;
    
    
    /**
     * 图片地址
     */
    @Transient
    private String picUrl;
    

    public Boolean getIsValid() {
		return isValid;
	}

	public void setIsValid(Boolean isValid) {
		this.isValid = isValid;
	}

	private static final long serialVersionUID = 1L;

    /**
     * @return id
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取内容名称
     *
     * @return content - 内容名称
     */
    public String getContent() {
        return content;
    }

    /**
     * 设置内容名称
     *
     * @param content 内容名称
     */
    public void setContent(String content) {
        this.content = content == null ? null : content.trim();
    }

    /**
     * 获取内容类型(1-语句内容,2-警示线,3-告知卡内容,4公告栏内容)
     *
     * @return type - 内容类型(1-语句内容,2-警示线,3-告知卡内容,4公告栏内容)
     */
    public Byte getType() {
        return type;
    }

    /**
     * 设置内容类型(1-语句内容,2-警示线,3-告知卡内容,4公告栏内容)
     *
     * @param type 内容类型(1-语句内容,2-警示线,3-告知卡内容,4公告栏内容)
     */
    public void setType(Byte type) {
        this.type = type;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

	public String getPicUrl() {
		return picUrl;
	}

	public void setPicUrl(String picUrl) {
		this.picUrl = picUrl;
	}
    
}