package cn.smarthse.modules.health.entity.base.wmbase;

import cn.smarthse.common.util.DateUtils;
import cn.smarthse.modules.health.enums.wmbase.WmBaseTypeEnum;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Table(name = "wm_base_list_view")
public class WmBaseListView implements Serializable {
    /**
     * 企业ID
     */
    private Long cid;

    /**
     * ID
     */
    @Id
    private Long id;

    /**
     * 区域ID
     */
    @Column(name = "area_id")
    private Long areaId;

    /**
     * 警示标识种类(系统参数Type)
     */
    @Column(name = "sign_type")
    private Long signType;

    /**
     * 责任部门ID
     */
    @Column(name = "dept_id")
    private Long deptId;

    /**
     * 区域名称
     */
    @Column(name = "area_name")
    private String areaName;

    /**
     * 负责人编号
     */
    @Column(name = "manager_id")
    private Long managerId;

    /**
     * 配置地点名称（具体位置）
     */
    @Column(name = "position_addr")
    private String positionAddr;

    /**
     * 组织名称
     */
    @Column(name = "organization_name")
    private String organizationName;

    /**
     * 负责人姓名
     */
    @Column(name = "manager_name")
    private String managerName;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 职业病危害因素(告知项目)
     */
    @Column(name = "name_chs")
    private String nameChs;
    
    /**
     * 警示内容
     */
    private String content;
   
    
    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid = true;
    
    @Column(name = "org_id")
    private String orgId;
    
    /**
     * 类型名称
     */
    @Transient
    private String signName;
    
    
    /**
     * 模糊搜索条件
     */
    @Transient
    private String keyword;
    
    
    /**
     * 查询排序
     */
    @Transient
    private String order;
    
    
    /**
     * 更新时间
     */
    @Transient
    private String upData;


    /**
     * 查询条件（多个区域id）
     */
    @Transient
    private List<Long> areaIds;

    public List<Long> getAreaIds() {
        return areaIds;
    }

    public void setAreaIds(List<Long> areaIds) {
        this.areaIds = areaIds;
    }

    public String getUpData() {
    	this.setUpData(upData);
		return upData;
	}

	public void setUpData(String upData) {
		if(updateDate != null){
			this.upData = DateUtils.getDate(updateDate);
		}
	}

	public String getKeyword() {
		return keyword;
	}

	public void setKeyword(String keyword) {
		this.keyword = keyword;
	}

	public String getOrder() {
		return order;
	}

	public void setOrder(String order) {
		this.order = order;
	}

	public String getSignName() {
    	this.setSignName();
		return signName;
	}

	public void setSignName() {
		if(signType!=null)
		this.signName = WmBaseTypeEnum.getName(signType.intValue());
	}

	private static final long serialVersionUID = 1L;

	
    public Boolean getIsValid() {
		return isValid;
	}

	public void setIsValid(Boolean isValid) {
		this.isValid = isValid;
	}

	/**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取区域ID
     *
     * @return area_id - 区域ID
     */
    public Long getAreaId() {
        return areaId;
    }

    /**
     * 设置区域ID
     *
     * @param areaId 区域ID
     */
    public void setAreaId(Long areaId) {
        this.areaId = areaId;
    }

    /**
     * 获取警示标识种类(系统参数Type)
     *
     * @return sign_type - 警示标识种类(系统参数Type)
     */
    public Long getSignType() {
        return signType;
    }

    /**
     * 设置警示标识种类(系统参数Type)
     *
     * @param signType 警示标识种类(系统参数Type)
     */
    public void setSignType(Long signType) {
        this.signType = signType;
    }

    /**
     * 获取责任部门ID
     *
     * @return dept_id - 责任部门ID
     */
    public Long getDeptId() {
        return deptId;
    }

    /**
     * 设置责任部门ID
     *
     * @param deptId 责任部门ID
     */
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    /**
     * 获取区域名称
     *
     * @return area_name - 区域名称
     */
    public String getAreaName() {
        return areaName;
    }

    /**
     * 设置区域名称
     *
     * @param areaName 区域名称
     */
    public void setAreaName(String areaName) {
        this.areaName = areaName == null ? null : areaName.trim();
    }

    /**
     * 获取负责人编号
     *
     * @return manager_id - 负责人编号
     */
    public Long getManagerId() {
        return managerId;
    }

    /**
     * 设置负责人编号
     *
     * @param managerId 负责人编号
     */
    public void setManagerId(Long managerId) {
        this.managerId = managerId;
    }

    /**
     * 获取配置地点名称（具体位置）
     *
     * @return position_addr - 配置地点名称（具体位置）
     */
    public String getPositionAddr() {
        return positionAddr;
    }

    /**
     * 设置配置地点名称（具体位置）
     *
     * @param positionAddr 配置地点名称（具体位置）
     */
    public void setPositionAddr(String positionAddr) {
        this.positionAddr = positionAddr == null ? null : positionAddr.trim();
    }

    /**
     * 获取组织名称
     *
     * @return organization_name - 组织名称
     */
    public String getOrganizationName() {
        return organizationName;
    }

    /**
     * 设置组织名称
     *
     * @param organizationName 组织名称
     */
    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName == null ? null : organizationName.trim();
    }

    /**
     * 获取姓名
     *
     * @return manager_name - 姓名
     */
    public String getManagerName() {
        return managerName;
    }

    /**
     * 设置姓名
     *
     * @param managerName 姓名
     */
    public void setManagerName(String managerName) {
        this.managerName = managerName == null ? null : managerName.trim();
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * @return name_chs
     */
    public String getNameChs() {
        return nameChs;
    }

    /**
     * @param nameChs
     */
    public void setNameChs(String nameChs) {
        this.nameChs = nameChs == null ? null : nameChs.trim();
    }

    /**
     * @return content
     */
    public String getContent() {
        return content;
    }

    /**
     * @param content
     */
    public void setContent(String content) {
        this.content = content == null ? null : content.trim();
    }

	

	public void setSignName(String signName) {
		this.signName = signName;
	}

	public String getOrgId() {
		return orgId;
	}

	public void setOrgId(String orgId) {
		this.orgId = orgId;
	}
    
}