package cn.smarthse.modules.health.entity.base.wmbase;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Table(name = "wm_base")
public class WmBase implements Serializable {
    /**
     * 自动编号
     */
    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业id
     */
    private Long cid;

    /**
     * 警示标识种类(系统参数Type)
     */
    @Column(name = "sign_type")
    private Long signType;

    /**
     * 区域ID
     */
    @Column(name = "area_id")
    private Long areaId;
    /**
     * 区域名称
     */
    @Column(name = "area_name")
    private String areaName;
    /**
     * 岗位ID
     */
    @Column(name = "work_id")
    private Long workId;
    /**
     * 岗位名称
     */
    @Column(name = "work_name")
    private String workName;


    /**
     * 配置地点名称（具体位置）
     */
    @Column(name = "position_addr")
    private String positionAddr;

    /**
     * 责任部门ID
     */
    @Column(name = "dept_id")
    private Long deptId;

    /**
     * 负责人编号
     */
    @Column(name = "manager_id")
    private Long managerId;
    /**
     * 负责人姓名
     */
    @Column(name = "manager_name")
    private String managerName;

    /**
     * 拍照时间
     */
    @Column(name = "photo_date")
    private Date photoDate;

    /**
     * 拍照附件
     */
    @Column(name = "photo_file_id")
    private Long photoFileId;

    /**
     * 备注说明
     */
    private String remark;

    /**
     * 1-正常,0-已删除
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 警示内容
     */
    private String content;

    /**
     * 组织部门
     */
    @Column(name = "org_id")
    private String orgId;
    static final long serialVersionUID = 1L;

    /**
     * 获取自动编号
     *
     * @return ID - 自动编号
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置自动编号
     *
     * @param id 自动编号
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业id
     *
     * @return cid - 企业id
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业id
     *
     * @param cid 企业id
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取警示标识种类(系统参数Type)
     *
     * @return sign_type - 警示标识种类(系统参数Type)
     */
    public Long getSignType() {
        return signType;
    }
    

    public String getOrgId() {
		return orgId;
	}

	public void setOrgId(String orgId) {
		this.orgId = orgId;
	}

	/**
     * 设置警示标识种类(系统参数Type)
     *
     * @param signType 警示标识种类(系统参数Type)
     */
    public void setSignType(Long signType) {
        this.signType = signType;
    }

    /**
     * 获取区域ID
     *
     * @return area_id - 区域ID
     */
    public Long getAreaId() {
        return areaId;
    }

    /**
     * 设置区域ID
     *
     * @param areaId 区域ID
     */
    public void setAreaId(Long areaId) {
        this.areaId = areaId;
    }

    /**
     * 获取配置地点名称（具体位置）
     *
     * @return position_addr - 配置地点名称（具体位置）
     */
    public String getPositionAddr() {
        return positionAddr;
    }

    /**
     * 设置配置地点名称（具体位置）
     *
     * @param positionAddr 配置地点名称（具体位置）
     */
    public void setPositionAddr(String positionAddr) {
        this.positionAddr = positionAddr == null ? null : positionAddr.trim();
    }

    /**
     * 获取责任部门ID
     *
     * @return dept_id - 责任部门ID
     */
    public Long getDeptId() {
        return deptId;
    }

    /**
     * 设置责任部门ID
     *
     * @param deptId 责任部门ID
     */
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    /**
     * 获取负责人编号
     *
     * @return manager_id - 负责人编号
     */
    public Long getManagerId() {
        return managerId;
    }

    /**
     * 设置负责人编号
     *
     * @param managerId 负责人编号
     */
    public void setManagerId(Long managerId) {
        this.managerId = managerId;
    }

    /**
     * 获取拍照时间
     *
     * @return photo_date - 拍照时间
     */
    public Date getPhotoDate() {
        return photoDate;
    }

    /**
     * 设置拍照时间
     *
     * @param photoDate 拍照时间
     */
    public void setPhotoDate(Date photoDate) {
        this.photoDate = photoDate;
    }

    /**
     * 获取拍照附件
     *
     * @return photo_file_id - 拍照附件
     */
    public Long getPhotoFileId() {
        return photoFileId;
    }

    /**
     * 设置拍照附件
     *
     * @param photoFileId 拍照附件
     */
    public void setPhotoFileId(Long photoFileId) {
        this.photoFileId = photoFileId;
    }

    /**
     * 获取备注说明
     *
     * @return remark - 备注说明
     */
    public String getRemark() {
        return remark;
    }

    /**
     * 设置备注说明
     *
     * @param remark 备注说明
     */
    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    /**
     * 获取1-正常,0-已删除
     *
     * @return is_valid - 1-正常,0-已删除
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置1-正常,0-已删除
     *
     * @param isValid 1-正常,0-已删除
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取最后修改人
     *
     * @return update_by - 最后修改人
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人
     *
     * @param updateBy 最后修改人
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取警示内容
     *
     * @return content - 警示内容
     */
    public String getContent() {
        return content;
    }

    /**
     * 设置警示内容
     *
     * @param content 警示内容
     */
    public void setContent(String content) {
        this.content = content == null ? null : content.trim();
    }

	public String getAreaName() {
		return areaName;
	}

	public void setAreaName(String areaName) {
		this.areaName = areaName;
	}

	public String getManagerName() {
		return managerName;
	}

	public void setManagerName(String managerName) {
		this.managerName = managerName;
	}

    public Long getWorkId() {
        return workId;
    }

    public void setWorkId(Long workId) {
        this.workId = workId;
    }

    public String getWorkName() {
        return workName;
    }

    public void setWorkName(String workName) {
        this.workName = workName;
    }
}