package cn.smarthse.modules.health.entity.base.wmbase;

import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;

/**
 * <p>
 * 现场示警标识管理-详情表
 * </p>
 *
 * @author zhangxuu
 * @since 2023-05-14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@Table(name = "warn_sign_manage_detail")
public class WarnSignManageDetail implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;
    /**
     * 示警标识管理主表id
     */
    private Long signManageId;

    /**
     * 车间名称
     */
    private String workshop;

    /**
     * 设置位置(检测点)
     */
    private String checkPoint;

    /**
     * 危害因素id,多个用,分隔
     */
    private String factorIds;

    /**
     * 危害因素名称,多个用,分隔
     */
    private String factorNames;

    /**
     * 警示标识种类,多个用,分隔(存的就是图片名称，然后查路径)
     */
    private String signTypeNames;

    /**
     * 警示图片路径
     */
    @Transient
    private Map<String,String> nameAndPathMap;

    /**
     * 告知卡种类名称,多个用,分隔
     */
    private String informCardNames;

    /**
     * 凭证文件位置
     */
    private String credentialFileId;

    /**
     * 系统附件
     */
    @Transient
    private SysFileModel file;

    /**
     * 是否通过检测数据自动生成的 1是0否
     */
    private Boolean isCheckGenerate;

    /**
     * 检测id
     */
    private Long checkId;

    /**
     * 创建人
     */
    private Long createBy;

    /**
     * 创建时间
     */
    private Date createDate;

    /**
     * 最后修改人ID
     */
    private Long updateBy;

    /**
     * 最后修改时间
     */
    private Date updateDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    private Boolean isValid;
}