package cn.smarthse.modules.health.entity.base.wmbase;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;


/**
 * <p>
 * 现场示警标识管理--v3.2.2.1新版
 * </p>
 *
 * @author zhangxuu
 * @since 2023-05-14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@Table(name = "warn_sign_manage")
public class WarnSignManage implements Serializable {
    private static final long serialVersionUID = 1L;

    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;
    @Transient
    private List<Long> cids;
    @Transient
    private String companyName;

    /**
     * 备注
     */
    private String remark;

    /**
     * 发放时间
     */
    private Date changeTime;

    /**
     * 审核状态：1草稿，2待审核，3退回，4审核完成，5无需审核,6已终止
     */
    private Integer reportState;

    /**
     * 填报方式：1整体填报，2部分填报
     */
    private Integer reportType;

    /**
     * 危害因素id,多个用,分隔
     */
    private String factorIds;

    /**
     * 因素名字
     */
    private String factorNames;


    /**
     * 创建人
     */
    private Long createBy;

    /**
     * 创建时间
     */
    private Date createDate;

    /**
     * 最后修改人ID
     */
    private Long updateBy;
    @Transient
    private String updateByStr;

    /**
     * 最后修改时间
     */
    private Date updateDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    private Boolean isValid;

    /**
     * 搜索年份
     */
    @Transient
    private Integer year;
    @Transient
    private Date beginTime;
    @Transient
    private Date endTime;

    /**
     * 关键字（防护用品）
     */
    @Transient
    private String kewWords;
    @Transient
    private List<WarnSignManageDetail> recordDetailList;

    // 关键因素画像id
    @Transient
    private Long keyFactoryId;
}
