package cn.smarthse.modules.health.entity.base.thirdparty;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Table(name = "tp_company")
public class TpCompany implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 企业类型（枚举）
     */
    @Column(name = "company_type")
    private Byte companyType;
    /**
     * 根据企业类别统计的企业数据量
     */
    @Transient
    private Integer companyTypeNum;
    
    @Transient
    private String excelAddress;
    /**
     * 导入出错原因
     */
    @Transient
    private String errorReason;
    @Transient
    private String companyTypeName;
    /**
     * 企业名称
     */
    @Column(name = "company_name")
    private String companyName;

    /**
     * 联系人
     */
    @Column(name = "contact_name")
    private String contactName;

    /**
     * 联系方式
     */
    @Column(name = "contact_tel")
    private String contactTel;
    @Transient
    private List<TpCertificate> certifiList;

    
    /**
     * 是否黑名单
     */
    @Column(name = "is_blacklist")
    private Boolean isBlacklist;

    /**
     * 加入黑名单原因
     */
    @Column(name = "black_reason")
    private String blackReason;

    /**
     * 加入黑名单的提交人(staff.id)
     */
    @Column(name = "black_submit")
    private Long blackSubmit;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建人对应的部门
     */
    @Column(name = "org_id")
    private Long orgId;
    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取企业类型（枚举）
     *
     * @return company_type - 企业类型（枚举）
     */
    public Byte getCompanyType() {
        return companyType;
    }

    public List<TpCertificate> getCertifiList() {
		return certifiList;
	}

	public void setCertifiList(List<TpCertificate> certifiList) {
		this.certifiList = certifiList;
	}

	public Integer getCompanyTypeNum() {
		return companyTypeNum;
	}

	public void setCompanyTypeNum(Integer companyTypeNum) {
		this.companyTypeNum = companyTypeNum;
	}

	/**
     * 设置企业类型（枚举）
     *
     * @param companyType 企业类型（枚举）
     */
    public void setCompanyType(Byte companyType) {
        this.companyType = companyType;
    }

    /**
     * 获取企业名称
     *
     * @return company_name - 企业名称
     */
    public String getCompanyName() {
        return companyName;
    }

    /**
     * 设置企业名称
     *
     * @param companyName 企业名称
     */
    public void setCompanyName(String companyName) {
        this.companyName = companyName == null ? null : companyName.trim();
    }

    /**
     * 获取联系人
     *
     * @return contact_name - 联系人
     */
    public String getContactName() {
        return contactName;
    }

    /**
     * 设置联系人
     *
     * @param contactName 联系人
     */
    public void setContactName(String contactName) {
        this.contactName = contactName == null ? null : contactName.trim();
    }

    /**
     * 获取联系方式
     *
     * @return contact_tel - 联系方式
     */
    public String getContactTel() {
        return contactTel;
    }

    /**
     * 设置联系方式
     *
     * @param contactTel 联系方式
     */
    public void setContactTel(String contactTel) {
        this.contactTel = contactTel == null ? null : contactTel.trim();
    }

    /**
     * 获取是否黑名单
     *
     * @return is_blacklist - 是否黑名单
     */
    public Boolean getIsBlacklist() {
        return isBlacklist;
    }

    /**
     * 设置是否黑名单
     *
     * @param isBlacklist 是否黑名单
     */
    public void setIsBlacklist(Boolean isBlacklist) {
        this.isBlacklist = isBlacklist;
    }

    /**
     * 获取加入黑名单原因
     *
     * @return black_reason - 加入黑名单原因
     */
    public String getBlackReason() {
        return blackReason;
    }

    /**
     * 设置加入黑名单原因
     *
     * @param blackReason 加入黑名单原因
     */
    public void setBlackReason(String blackReason) {
        this.blackReason = blackReason == null ? null : blackReason.trim();
    }

    /**
     * 获取加入黑名单的提交人(staff.id)
     *
     * @return black_submit - 加入黑名单的提交人(staff.id)
     */
    public Long getBlackSubmit() {
        return blackSubmit;
    }

    /**
     * 设置加入黑名单的提交人(staff.id)
     *
     * @param blackSubmit 加入黑名单的提交人(staff.id)
     */
    public void setBlackSubmit(Long blackSubmit) {
        this.blackSubmit = blackSubmit;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

	public String getErrorReason() {
		return errorReason;
	}

	public void setErrorReason(String errorReason) {
		this.errorReason = errorReason;
	}

	public String getExcelAddress() {
		return excelAddress;
	}

	public void setExcelAddress(String excelAddress) {
		this.excelAddress = excelAddress;
	}

	public String getCompanyTypeName() {
		return companyTypeName;
	}

	public void setCompanyTypeName(String companyTypeName) {
		this.companyTypeName = companyTypeName;
	}

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
}