package cn.smarthse.modules.health.entity.base.thirdparty;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import lombok.Data;

@Table(name = "tp_certificate")
public @Data class TpCertificate implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 三方企业编号(TPCompany.id)
     */
    @Column(name = "tp_id")
    private Long tpId;

    /**
     * 证书名称
     */
    private String name;

    /**
     * 有效期至
     */
    @Column(name = "validity_date")
    private Date validityDate;

    /**
     * 证书编号
     */
    private String no;

    /**
     * 电子附件编号(File.ID)
     */
    @Column(name = "attachment_id")
    private String attachmentId;

    
    /**
     * 附件信息
     */
    @Transient
    private List<SysFileModel> attachment;
    /**
     * 纸质存放位置
     */
    @Deprecated
    @Column(name = "paper_location")
    private String paperLocation;

    /**
     * 是否是初始化添加的证
     */
    @Column(name = "is_initCerti")
    private Boolean isInitCerti;
    
    /**
     * 是否是必须的证书(便于前端展示)
     */
    @Column(name = "is_required")
    private Boolean isRequired;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;
}