package cn.smarthse.modules.health.entity.base.staff.vo;

import cn.smarthse.common.util.DateUtils;

import java.io.Serializable;
import java.util.Date;

public class StaffBasicVo implements Serializable{

	private static final long serialVersionUID = 5577024134231091978L;

	private Long cid;
	
	private Long staffId;

	private Long staffBasicInfoId;
	
	private String staffName;
	
	private String workNo;
	
	private Long deptId;
	
	private String deptName;
	
	private Long workId;
	
	private String workName;
	
	private String jobTitle;
	
	private Boolean isValid;
	
	private String genderName;	
	/**
     * 性别 0:女 1：男
     */
    private Byte gender;   
    /**
     * 生日
     */
    private Date birthday;
	
	private String birthdayString;
	
	private String mobile;

	private String idCard;

	private boolean isNew = false;

	private String companyName;

	private Byte workStatus;


	private String harms;


	public String getHarms() {
		return harms;
	}

	public void setHarms(String harms) {
		this.harms = harms;
	}

	public String getGenderName() {
		if(this.gender == null) genderName="";
		else if(this.gender == 0) genderName="女";
		else if(this.gender == 1) genderName="男";
		return genderName;
	}

	public void setGenderName(String genderName) {
		this.genderName = genderName;
	}

	public Byte getGender() {
		return gender;
	}

	public void setGender(Byte gender) {
		this.gender = gender;
	}

	public Date getBirthday() {
		return birthday;
	}

	public void setBirthday(Date birthday) {
		this.birthday = birthday;
	}

	public String getBirthdayString() {
		if(this.birthday!=null){
			this.birthdayString = DateUtils.format(this.birthday, "yyyy-MM-dd"); 
		}else {
			this.birthdayString = "";
		}
		return birthdayString;
	}

	public void setBirthdayString(String birthdayString) {
		this.birthdayString = birthdayString;
	}

	public Long getStaffId() {
		return staffId;
	}

	public void setStaffId(Long staffId) {
		this.staffId = staffId;
	}

	public String getStaffName() {
		return staffName;
	}

	public void setStaffName(String staffName) {
		this.staffName = staffName;
	}

	public String getWorkNo() {
		return workNo;
	}

	public void setWorkNo(String workNo) {
		this.workNo = workNo;
	}

	public Long getDeptId() {
		return deptId;
	}

	public void setDeptId(Long deptId) {
		this.deptId = deptId;
	}

	public String getDeptName() {
		return deptName;
	}

	public void setDeptName(String deptName) {
		this.deptName = deptName;
	}

	public Boolean getIsValid() {
		return isValid;
	}

	public void setIsValid(Boolean isValid) {
		this.isValid = isValid;
	}

	public Long getWorkId() {
		return workId;
	}

	public void setWorkId(Long workId) {
		this.workId = workId;
	}

	public String getWorkName() {
		return workName;
	}

	public void setWorkName(String workName) {
		this.workName = workName;
	}

	public String getJobTitle() {
		return jobTitle;
	}

	public void setJobTitle(String jobTitle) {
		this.jobTitle = jobTitle;
	}

	public String getMobile() {
		return mobile;
	}

	public void setMobile(String mobile) {
		this.mobile = mobile;
	}

	public String getIdCard() {
		return idCard;
	}

	public void setIdCard(String idCard) {
		this.idCard = idCard;
	}

	public boolean isNew() {
		return isNew;
	}

	public void setNew(boolean aNew) {
		isNew = aNew;
	}

	public Long getCid() {
		return cid;
	}

	public void setCid(Long cid) {
		this.cid = cid;
	}

	public Long getStaffBasicInfoId() {
		return staffBasicInfoId;
	}

	public void setStaffBasicInfoId(Long staffBasicInfoId) {
		this.staffBasicInfoId = staffBasicInfoId;
	}

	public String getCompanyName() {
		return companyName;
	}

	public void setCompanyName(String companyName) {
		this.companyName = companyName;
	}

	public Byte getWorkStatus() {
		return workStatus;
	}

	public void setWorkStatus(Byte workStatus) {
		this.workStatus = workStatus;
	}
}
