package cn.smarthse.modules.health.entity.base.staff.vo;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import lombok.Data;

/**
 * 《》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <体检推荐人清单查询>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author BinXu(徐斌) [784514607@qq.com]
 * @since 2018年1月25日-上午10:05:02
 */
public @Data  class HealthCheckStaffInfoQuery implements  Serializable {/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private Long cid;
	
	/**
	 * 不包含的人员
	 */
	private List<Long>  staffIds;
	
	/**
	 * 搜索条件(工号或者姓名)
	 */
	private String searchKey;
	
	/**
	 * 性别
	 */
	private Byte  gender;
	
	/**
	 * 部门/车间
	 */
	private List<Long> orgIds;
	
	/**
	 * 当前岗位
	 */
	private Long workId;
	
	/**
	 * 兼职岗位
	 */
	private List<Long> pluralityIds;
	
	/**
	 * 包含的人员
	 */
	private List<Long>  includeStaffIds;

	/**
	 * 上次体检时间
	 */
	private Date  lastCheckBeginTime;
	
	/**
	 * 上次体检时间
	 */
	private Date  lastCheckEndTime;
	
	private String must;
	
	private String choose;
	
	/**
	 * 体检推荐人员清单（在岗期间职业健康检查） 上岗时间大于 选项：>0天、>30天、>60天、>90天（默认）、>180天、>360天
	 * 
	 */
	private String workTimeRange;
	
	
	
	/**
	 * 体检推荐人员清单（上岗前职业健康检查）(上岗时间)
	 * 
	 * 	体检推荐人员清单（离岗时职业健康检查）(离岗时间)
	 */
	private Date  workTimeBegin;
	
	private Date workTimeEnd;
}
