package cn.smarthse.modules.health.entity.base.staff.importstaff;

import cn.smarthse.modules.health.entity.base.company.CompanyOrganization;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicWork;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffWorkRole;
import cn.smarthse.modules.health.entity.base.workinfo.WorkRoleInfo;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 《人员导入实体类》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author BinXu(徐斌) [784514607@qq.com]
 * @since 2017年12月25日-上午8:56:19
 */
public  @Data class StaffInfoExcelImportVo  implements Serializable{/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	/**
	 * 人员导入的状态,1:正常的状态,默认为1 ，2是数据存在错误的状态 3是数据在数据库已存在的状态 4表示跳过改行不更新（Excel每行没有必填数据或者该行数据为空）
	 * 
	 */
	private Byte dataState;

	private Byte role;
	
	private Long cid;
	
	private Long loginStaffId;
	
	
	/**
	 * 把每一行的每一列的值放到map里 key：列号 value：单元格的值 
	 */
	private Map<String, String> keyValue=new HashMap<>();
	
	/**
	 * 人员基本信息
	 */
	private StaffBasicInfo staffBasicInfo=new StaffBasicInfo();
	
	/**
	 * 人员信息
	 */
	private StaffInfo staffInfo=new StaffInfo();
	
	/**
	 * 人员基本岗位信息
	 */
	private StaffBasicWork staffBasicWork=new StaffBasicWork();
	
	/**
	 * 人员当前岗位具体信息
	 */
	private StaffWorkRole currentStaffWorkRole=new StaffWorkRole();
	
    /**
     * 需要保存的岗位数据
     */
    private WorkRoleInfo needSaveWorkRoleInfo;	
    
    
    /**
     * 两个key： self：来自部门/车间列的数据  work：来自岗位/工种列的数据
     */
    private Map<String, List<CompanyOrganization>>  needSaveComOrgs=new HashMap<>();
	
	/**
	 * 不能导入数据的原因
	 */
	private String errorReason;

	/**
	 * 岗位是否存在
	 */
	private Boolean isHaveWork=true;
	/**
	 * 是否第三访企业（劳动派遣）
	 */
	private Boolean isThirdCompany;
	
	/**
     *  2.5版本 null:为本企业 1:代表劳动派遣(当isThirdParty是true的时候使用) 2：代表外包(当isThirdParty是true的时候使用)
     *  2.6版本专为外来人员使用  1:代表劳动派遣 2：代表外包，3代表其他
     *   
     */
	private Byte outsource;
	
	/**
	 * 派遣企业名称（必填项）
	 */
	private String thirdCompanyName;
	
	/**1
	 * 工号
	 */
	private String workNo;
	
	/**2
	 * 姓名（必填项）
	 */
	private String realName;
	
	/**3
	 * 部门/车间（必填项）
	 */
	private String deptName;
	
	private Long deptId;
	
	/**4
	 * 岗位/工种（必填项）
	 */
	private String workName;
	
	private Long workId;
	
	/**5
	 * 性别
	 */
	private String sexName;
	
	private Byte gender;
	
	/**6
	 * 手机号码（必填项）
	 */
	private String mobile;
	
	/**7
	 * 身份证号（必填）
	 */
	private String cardNo;
    private Long staffBasicId;
    private Long staffInfoId;
    private Long staffBasicWorkId;
    private Long staffWorkRoleId;
	
	private Date birthDay;
	
	private Integer age;
	
	/**8
	 * 岗位状态（必填项）
	 */
	private String workStateName;
	
	private Byte workState;
	
	/**9
	 * 公司职务
	 */
	private String companyJob;
	
	/**10
	 * 籍贯
	 */
	private String nativePlace;
	
	/**11
	 * 民族
	 */
	private String nation;
	
	/**12
	 * 婚姻状况
	 */
	private String marriageState;
	
	private Byte maritalStatus;
	
	/**13
	 * 学历
	 */
	private String education;
	
	private Long educationId;
	
	/**14
	 * 专业
	 */
	private String major;
	
	/**15
	 * 进厂时间
	 * 
	 */
	private String joinTime;
	
	private Date joinDate;
	
	/**16
	 * 参加工作时间
	 */
	private String beginWorkTime;
	
	private Date beginWorkDate;
	
	/**17
	 * 是否放射人员
	 */
	private String isRadiationName;
	
	private Boolean isRadiation; 
	
	/**18
	 * 从事放射工作起始时间
	 */
	private String radiationYearName;
	
	private Date radiationYear;
	
	/**19
	 * 职业照射职业分类
	 */
	private String radiationTypeName;
	
	private Long radiationType;
	
	/**20
	 * 特种作业
	 */
	private String specialOperationsName;
	
	private Long specialOperations;
	
	/**21
	 * 特殊作业（参见gbz188）
	 */
	private String specialWorkName;
	
	private Long specialWork;
	/**
	 * 嗜好
	 */
	private String hobby;

}
