package cn.smarthse.modules.health.entity.base.staff;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Table(name = "work_nature_info")
public class WorkNatureInfo implements Serializable {
	
	
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 人员信息ID
     */
    @Column(name = "staff_id")
    private Long staffId;

   

    /**
     * 作业性质：1.放射工作、2特种作业、3特殊作业（常见GBZ188）
     */
    private Byte nature;
    
    @Column(name = "nature_name")
    private String natureName;

    /**
     * 是否默认项（0-不是默认，1-默认）
     */
    @Column(name = "is_default")
    private Boolean isDefault;
    
    /**
     * 是否从事（0-否，1-是）
     */
    @Column(name = "is_work")
    private Boolean isWork;

   /**
     * 职业照射的职业分类及其代码/类型
     */
    @Column(name = "work_type")
    private String workType;

    /**
     * 开始从事时间时间
     */
    @Column(name = "work_begin_time")
    private Date workBeginTime;

    /**
     * 结束从事时间
     */
    @Column(name = "work_end_time")
    private Date workEndTime;

  

 

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;
    
   @Transient
   private String radiationWork;
   
   @Transient
   private String particularWork;
   
   @Transient
   private String specialWork;

    private static final long serialVersionUID = 1L;



	public Long getId() {
		return id;
	}



	public void setId(Long id) {
		this.id = id;
	}



	public Long getCid() {
		return cid;
	}



	public void setCid(Long cid) {
		this.cid = cid;
	}



	public Long getStaffId() {
		return staffId;
	}



	public void setStaffId(Long staffId) {
		this.staffId = staffId;
	}



	public Byte getNature() {
		return nature;
	}



	public void setNature(Byte nature) {
		this.nature = nature;
	}



	public Boolean getIsDefault() {
		return isDefault;
	}



	public void setIsDefault(Boolean isDefault) {
		this.isDefault = isDefault;
	}



	public Boolean getIsWork() {
		return isWork;
	}



	public void setIsWork(Boolean isWork) {
		this.isWork = isWork;
	}

	

	public String getNatureName() {
		return natureName;
	}



	public void setNatureName(String natureName) {
		this.natureName = natureName;
	}



	public String getWorkType() {
		return workType;
	}



	public void setWorkType(String workType) {
		this.workType = workType;
	}



	public Date getWorkBeginTime() {
		return workBeginTime;
	}



	public void setWorkBeginTime(Date workBeginTime) {
		this.workBeginTime = workBeginTime;
	}



	public Date getWorkEndTime() {
		return workEndTime;
	}



	public void setWorkEndTime(Date workEndTime) {
		this.workEndTime = workEndTime;
	}



	public Boolean getIsValid() {
		return isValid;
	}



	public void setIsValid(Boolean isValid) {
		this.isValid = isValid;
	}



	public Long getCreateBy() {
		return createBy;
	}



	public void setCreateBy(Long createBy) {
		this.createBy = createBy;
	}



	public Date getCreateDate() {
		return createDate;
	}



	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}



	public Long getUpdateBy() {
		return updateBy;
	}



	public void setUpdateBy(Long updateBy) {
		this.updateBy = updateBy;
	}



	public Date getUpdateDate() {
		return updateDate;
	}



	public void setUpdateDate(Date updateDate) {
		this.updateDate = updateDate;
	}



	public String getRadiationWork() {
		return radiationWork;
	}



	public void setRadiationWork(String radiationWork) {
		this.radiationWork = radiationWork;
	}



	public String getParticularWork() {
		return particularWork;
	}



	public void setParticularWork(String particularWork) {
		this.particularWork = particularWork;
	}



	public String getSpecialWork() {
		return specialWork;
	}



	public void setSpecialWork(String specialWork) {
		this.specialWork = specialWork;
	}
	
  
}