package cn.smarthse.modules.health.entity.base.staff;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

@Table(name = "supervise_staff_list")
public class SuperviseStaffList implements Serializable {
    @Id
    private Long id;

    private Long cid;

    /**
     * 省编号
     */
    @Column(name = "province_id")
    private Long provinceId;
    /**
     * 市编号
     */
    @Column(name = "city_id")
    private Long cityId;
    /**
     * 区域ID
     */
    @Column(name = "area_id")
    private Long areaId;
    /**
     * 乡镇街道编号
     */
    @Column(name = "street_id")
    private Long streetId;

    @Column(name = "staff_id")
    private Long staffId;

    @Column(name = "staff_name")
    private String staffName;

    @Column(name = "id_card")
    private String idCard;

    private Integer gender;

    @Column(name = "gender_name")
    private String genderName;

    @Column(name = "company_name")
    private String companyName;

    @Column(name = "company_address")
    private String companyAddress;

    @Column(name = "harm_ids")
    private String harmIds;

    @Column(name = "harm_names")
    private String harmNames;

    /**
     * 最新体检结果
     */
    @Column(name = "last_exam_result")
    private String lastExamResult;

    @Column(name = "last_exam_result_name")
    private String lastExamResultName;
    
    /**
     * 是逗职业病患者
     */
    @Column(name = "is_diseases_patient")
    private Boolean isDiseasesPatient;

    @Column(name = "create_date")
    private Date createDate;
    
    @Transient
    private Long diseaserId;

    private static final long serialVersionUID = 1L;

    /**
     * @return id
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * @return cid
     */
    public Long getCid() {
        return cid;
    }

    /**
     * @param cid
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * @return area_id
     */
    public Long getAreaId() {
        return areaId;
    }

    /**
     * @param areaId
     */
    public void setAreaId(Long areaId) {
        this.areaId = areaId;
    }

    /**
     * @return staff_id
     */
    public Long getStaffId() {
        return staffId;
    }

    /**
     * @param staffId
     */
    public void setStaffId(Long staffId) {
        this.staffId = staffId;
    }

    /**
     * @return staff_name
     */
    public String getStaffName() {
        return staffName;
    }

    /**
     * @param staffName
     */
    public void setStaffName(String staffName) {
        this.staffName = staffName == null ? null : staffName.trim();
    }

    /**
     * @return id_card
     */
    public String getIdCard() {
        return idCard;
    }

    /**
     * @param idCard
     */
    public void setIdCard(String idCard) {
        this.idCard = idCard == null ? null : idCard.trim();
    }

    /**
     * @return gender
     */
    public Integer getGender() {
        return gender;
    }

    /**
     * @param gender
     */
    public void setGender(Integer gender) {
        this.gender = gender;
    }

    /**
     * @return gender_name
     */
    public String getGenderName() {
        return genderName;
    }

    /**
     * @param genderName
     */
    public void setGenderName(String genderName) {
        this.genderName = genderName == null ? null : genderName.trim();
    }

    /**
     * @return company_name
     */
    public String getCompanyName() {
        return companyName;
    }

    /**
     * @param companyName
     */
    public void setCompanyName(String companyName) {
        this.companyName = companyName == null ? null : companyName.trim();
    }

    /**
     * @return company_address
     */
    public String getCompanyAddress() {
        return companyAddress;
    }

    /**
     * @param companyAddress
     */
    public void setCompanyAddress(String companyAddress) {
        this.companyAddress = companyAddress == null ? null : companyAddress.trim();
    }

    /**
     * @return harm_ids
     */
    public String getHarmIds() {
        return harmIds;
    }

    /**
     * @param harmIds
     */
    public void setHarmIds(String harmIds) {
        this.harmIds = harmIds == null ? null : harmIds.trim();
    }

    /**
     * @return harm_names
     */
    public String getHarmNames() {
        return harmNames;
    }

    /**
     * @param harmNames
     */
    public void setHarmNames(String harmNames) {
        this.harmNames = harmNames == null ? null : harmNames.trim();
    }

    /**
     * 获取最新体检结果
     *
     * @return last_exam_result - 最新体检结果
     */
    public String getLastExamResult() {
        return lastExamResult;
    }

    /**
     * 设置最新体检结果
     *
     * @param lastExamResult 最新体检结果
     */
    public void setLastExamResult(String lastExamResult) {
        this.lastExamResult = lastExamResult == null ? null : lastExamResult.trim();
    }

    /**
     * @return last_exam_result_name
     */
    public String getLastExamResultName() {
        return lastExamResultName;
    }

    /**
     * @param lastExamResultName
     */
    public void setLastExamResultName(String lastExamResultName) {
        this.lastExamResultName = lastExamResultName == null ? null : lastExamResultName.trim();
    }

    /**
     * @return create_date
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * @param createDate
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Long getProvinceId() {
        return provinceId;
    }

    public void setProvinceId(Long provinceId) {
        this.provinceId = provinceId;
    }

    public Long getCityId() {
        return cityId;
    }

    public void setCityId(Long cityId) {
        this.cityId = cityId;
    }

    public Long getStreetId() {
        return streetId;
    }

    public void setStreetId(Long streetId) {
        this.streetId = streetId;
    }

	public Boolean getIsDiseasesPatient() {
		return isDiseasesPatient;
	}

	public void setIsDiseasesPatient(Boolean isDiseasesPatient) {
		this.isDiseasesPatient = isDiseasesPatient;
	}

	public Long getDiseaserId() {
		return diseaserId;
	}

	public void setDiseaserId(Long diseaserId) {
		this.diseaserId = diseaserId;
	}
    
}