package cn.smarthse.modules.health.entity.base.staff;

import cn.smarthse.modules.health.entity.base.workinfo.WorkRoleInfo;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Table(name = "staff_work_role")
public class StaffWorkRole implements Serializable {

	/**
	 * 告知Id（合同告知里面的Id）
	 */
	@Column(name = "inform_id")
	private Long informId;

	/**
	 * 该岗位是否已告知（0默认为未告知）
	 */
	@Column(name = "inform_status")
	private Byte informStatus;

	/**
	 * 当前岗位名称
	 */
	@Transient
	private String currentWorkName;

	/**
	 * 具体的岗位信息
	 */
	@Transient
	private WorkRoleInfo workRoleInfo;

	/**
	 * 接触的职业病危害因素
	 */
	@Transient
	private String contactHarm;

    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 人员信息ID
     */
    @Column(name = "staff_id")
    private Long staffId;

    /**
     * 岗位属性：1：主岗位；2：兼职岗位
     */
    @Column(name = "work_property")
    private Byte workProperty;

    /**
     * 岗位ID
     */
    @Column(name = "work_role_id")
    private Long workRoleId;

    /**
     * 岗位状态1在岗；2离岗；3休假
     */
    private Byte status;

    /**
     * 0：本企业 1：第三方企业(0(false):是厂内工作经历 1(true):厂外工作经历)
     */
    @Column(name = "is_third_party")
    private Boolean isThirdParty;

    /**
     * 应该是外协的企业id
     */
    @Column(name = "third_party_cid")
    private Long thirdPartyCid;

    /**
     * 上岗时间
     */
    @Column(name = "begin_time")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date beginTime;

    /**
     * 本岗位入职时间（字符串格式），数据源字段：beginTime；此字段可作为 出/入参 的传递。
     */
    @Transient
    private String currentJobBeginTime;

    /**
     * 转/离岗时间
     */
    @Column(name = "leave_time")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date leaveTime;

    /**
     * 首次上岗时间
     */
    @Column(name = "first_begin_time")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date firstBeginTime;

    /**
     * 厂外企业岗位名称
     */
    @Column(name = "other_company_work")
    private String otherCompanyWork;

    /**
     * 是否为历史记录 0为否  1为是
     */
    @Column(name = "is_history")
    private Boolean isHistory;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 厂外工作经历企业名称
     */
    @Column(name = "other_company_name")
    private String otherCompanyName;

    /**
     * 特殊作业
     */
    @Column(name = "special_operation")
    private String specialOperation;

    /**
     * 数据来源（1 万达仓)
     */
    @Column(name = "data_source")
    private Byte dataSource;

    /**
     * 数据修改来源（1 万达仓)
     */
    @Column(name = "data_update_source")
    private Byte dataUpdateSource;

    /**
     * 姓名
     */
    @Transient
    private String staffName;
    @Transient
    private String idCard;
    /**
     * 工号
     */
    @Transient
    private String workNo;

    /**
     * 在岗时间
     */
    @Transient
    private String onWorkTime;

    /**
     * 劳动者培训人员是否被选中（0-未选中，1-选中）
     */
    @Transient
    private Integer isChoose;

    /**
     * 部门id
     */
    @Transient
    private Long orgId;

    @Transient
    private String wandaHealthCardSourceId;

    /**
     * 排序依据（1姓名首字母 2本岗位入职时间）
     */
    @Transient
    private Byte sortBy;


    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取人员信息ID
     *
     * @return staff_id - 人员信息ID
     */
    public Long getStaffId() {
        return staffId;
    }

    /**
     * 设置人员信息ID
     *
     * @param staffId 人员信息ID
     */
    public void setStaffId(Long staffId) {
        this.staffId = staffId;
    }

    /**
     * 获取岗位属性：1：主岗位；2：兼职岗位
     *
     * @return work_property - 岗位属性：1：主岗位；2：兼职岗位
     */
    public Byte getWorkProperty() {
        return workProperty;
    }

    /**
     * 设置岗位属性：1：主岗位；2：兼职岗位
     *
     * @param workProperty 岗位属性：1：主岗位；2：兼职岗位
     */
    public void setWorkProperty(Byte workProperty) {
        this.workProperty = workProperty;
    }

    /**
     * 获取岗位ID
     *
     * @return work_role_id - 岗位ID
     */
    public Long getWorkRoleId() {
        return workRoleId;
    }

    /**
     * 设置岗位ID
     *
     * @param workRoleId 岗位ID
     */
    public void setWorkRoleId(Long workRoleId) {
        this.workRoleId = workRoleId;
    }

    /**
     * 获取岗位状态1在岗；2离岗；3休假
     *
     * @return status - 岗位状态1在岗；2离岗；3休假
     */
    public Byte getStatus() {
        return status;
    }

    /**
     * 设置岗位状态1在岗；2离岗；3休假
     *
     * @param status 岗位状态1在岗；2离岗；3休假
     */
    public void setStatus(Byte status) {
        this.status = status;
    }

    /**
     * 获取0：本企业 1：第三方企业
     *
     * @return is_third_party - 0：本企业 1：第三方企业
     */
    public Boolean getIsThirdParty() {
        return isThirdParty;
    }

    /**
     * 设置0：本企业 1：第三方企业
     *
     * @param isThirdParty 0：本企业 1：第三方企业
     */
    public void setIsThirdParty(Boolean isThirdParty) {
        this.isThirdParty = isThirdParty;
    }

    /**
     * 获取应该是外协的企业id
     *
     * @return third_party_cid - 应该是外协的企业id
     */
    public Long getThirdPartyCid() {
        return thirdPartyCid;
    }

    /**
     * 设置应该是外协的企业id
     *
     * @param thirdPartyCid 应该是外协的企业id
     */
    public void setThirdPartyCid(Long thirdPartyCid) {
        this.thirdPartyCid = thirdPartyCid;
    }

    /**
     * 获取上岗时间
     *
     * @return begin_time - 上岗时间
     */
    public Date getBeginTime() {
        return beginTime;
    }

    /**
     * 设置上岗时间
     *
     * @param beginTime 上岗时间
     */
    public void setBeginTime(Date beginTime) {
        this.beginTime = beginTime;
    }

    public String getCurrentJobBeginTime() {
        return currentJobBeginTime;
    }

    public void setCurrentJobBeginTime(String currentJobBeginTime) {
        this.currentJobBeginTime = currentJobBeginTime;
    }

    /**
     * 获取转/离岗时间
     *
     * @return leave_time - 转/离岗时间
     */
    public Date getLeaveTime() {
        return leaveTime;
    }

    /**
     * 设置转/离岗时间
     *
     * @param leaveTime 转/离岗时间
     */
    public void setLeaveTime(Date leaveTime) {
        this.leaveTime = leaveTime;
    }

    public Date getFirstBeginTime() {
        return firstBeginTime;
    }

    public void setFirstBeginTime(Date firstBeginTime) {
        this.firstBeginTime = firstBeginTime;
    }

    /**
     * 获取厂外企业岗位名称
     *
     * @return other_company_work - 厂外企业岗位名称
     */
    public String getOtherCompanyWork() {
        return otherCompanyWork;
    }

    /**
     * 设置厂外企业岗位名称
     *
     * @param otherCompanyWork 厂外企业岗位名称
     */
    public void setOtherCompanyWork(String otherCompanyWork) {
        this.otherCompanyWork = otherCompanyWork == null ? null : otherCompanyWork.trim();
    }

    /**
     * 获取是否为历史记录 0为否  1为是
     *
     * @return is_history - 是否为历史记录 0为否  1为是
     */
    public Boolean getIsHistory() {
        return isHistory;
    }

    /**
     * 设置是否为历史记录 0为否  1为是
     *
     * @param isHistory 是否为历史记录 0为否  1为是
     */
    public void setIsHistory(Boolean isHistory) {
        this.isHistory = isHistory;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

	public WorkRoleInfo getWorkRoleInfo() {
		return workRoleInfo;
	}

	public void setWorkRoleInfo(WorkRoleInfo workRoleInfo) {
		this.workRoleInfo = workRoleInfo;
	}

	/**
     * 获取厂外工作经历企业名称
     *
     * @return other_company_name - 最后修改时间
     */
	public String getOtherCompanyName() {
		return otherCompanyName;
	}

	/**
     * 设置厂外工作经历企业名称
     *
     * @return other_company_name - 最后修改时间
     */
	public void setOtherCompanyName(String otherCompanyName) {
		this.otherCompanyName = otherCompanyName;
	}

	public String getCurrentWorkName() {
		return currentWorkName;
	}

	public void setCurrentWorkName(String currentWorkName) {
		this.currentWorkName = currentWorkName;
	}

	public Byte getInformStatus() {
		return informStatus;
	}
	public void setInformStatus(Byte informStatus) {
		this.informStatus = informStatus;
	}

	public Long getInformId() {
		return informId;
	}

	public void setInformId(Long informId) {
		this.informId = informId;
	}

	public String getStaffName() {
		return staffName;
	}

	public void setStaffName(String staffName) {
		this.staffName = staffName;
	}

	public String getWorkNo() {
		return workNo;
	}

	public void setWorkNo(String workNo) {
		this.workNo = workNo;
	}

	public String getOnWorkTime() {
		return onWorkTime;
	}

	public void setOnWorkTime(String onWorkTime) {
		this.onWorkTime = onWorkTime;
	}

	public String getContactHarm() {
		return contactHarm;
	}

	public void setContactHarm(String contactHarm) {
		this.contactHarm = contactHarm;
	}

    public String getSpecialOperation() {
        return specialOperation;
    }

    public void setSpecialOperation(String specialOperation) {
        this.specialOperation = specialOperation;
    }

    public Byte getDataSource() {
        return dataSource;
    }

    public void setDataSource(Byte dataSource) {
        this.dataSource = dataSource;
    }

    public Byte getDataUpdateSource() {
        return dataUpdateSource;
    }

    public void setDataUpdateSource(Byte dataUpdateSource) {
        this.dataUpdateSource = dataUpdateSource;
    }

    public Integer getIsChoose() {
        return isChoose;
    }

    public void setIsChoose(Integer isChoose) {
        this.isChoose = isChoose;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }

    public String getWandaHealthCardSourceId() {
        return wandaHealthCardSourceId;
    }

    public void setWandaHealthCardSourceId(String wandaHealthCardSourceId) {
        this.wandaHealthCardSourceId = wandaHealthCardSourceId;
    }
}
