package cn.smarthse.modules.health.entity.base.staff;

import cn.smarthse.common.util.StringMixedUtil;
import cn.smarthse.modules.health.entity.base.company.CompanyOrganization;
import cn.smarthse.modules.health.entity.base.workinfo.WorkRoleInfo;
import cn.smarthse.modules.health.enums.staff.StaffGenderEnum;
import cn.smarthse.modules.health.enums.staff.StaffMaritalStatusEnum;
import cn.smarthse.modules.health.enums.staff.StaffWorkStatusEnum;

import java.io.Serializable;
import java.util.Date;

public class StaffShowInfo implements Serializable{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private Long id;
	
	private Long contractInformId;
	
	/**
	 * 当前岗位上岗时间
	 */
	private Date  currentWorkBeginTime;

    /**
     * 首次上岗时间
     */
    private Date firstBeginTime;
	
	/**
	 * 当前岗位离岗时间
	 */
	private Date  currentWorkLeaveTime;
	
	//工号
	private String workNo;
	//姓名
	private String realName;
	//性别
	private String sexName;
	//部门/车间
	private  String orgName;
	//岗位/工种
	private  String workName;
	//岗位状态
	private  String workStatusName;
	//性别标识0:女 1：男
	private Integer gender;
	//组织ID
	private Long orgId;
	//当前工种/岗位ID
	private Long workRoleId;
	//当前岗位/工种状态  岗位状态1在岗；2离岗；3休假
	private Byte  workStatus;
    //更新时间
	private  Date updateDate;
	//劳务派遣公司名称
	private  String otherCompany;
	//组织
	private  CompanyOrganization org;
	//当前岗位
	private  WorkRoleInfo currentWork;
	
    /**
     * 用工形式 1 劳动派遣 2 外包  3 其他 0为空
     */
    private String outsourceName;
    
    /**
     * 用工形式 1 劳动派遣 2 外包  3 其他 0为空
     */
    private Byte outsource;
	  /**
     * 身份证号
     */
    private String idCard;
    
    private String idCardNo;
    
    /**
     * 出生日期
     */
    private Date  birthday;
    
    /**
     * 年龄
     */
    private Integer age;
    
    /**
     * 籍贯
     */
    private String nativePlace;
    
    
    /**
     * 婚姻
     */
    private  Byte  marriage;
    
    private String marriageName;
    
    /**
     * 民族
     */
    private String nation;
    
    /**
     * 学历
     */
    private Long education;
    
    private String educationName;
    
    /**
     * 专业
     */
    private String  major;
    
    /**
     * 手机号码
     */
    private String phoneNo;
    
    /**
     * 邮箱
     */
    private String email;
    
    /**
     * 参加工作时间
     */
    private Date  joinTime;
    
    /**
     * 进厂时间
     */
    private Date  workTime;
    
    /**
     * 职务
     */
    private String jobTitle;
    
    /**
     * 兼职岗位
     */
    private String plurality;
    
    /**
     * 放射工作人员
     */
    private Boolean  isRadiation;
    
    private String isRadiationName;
    
    
    /**
     * 起始从事放射工作时间
     */
    private Date  radiationYear;
    
    /**
     * 职业照射的职业分类及其代码
     */
    private Long radiationType;
    
    private String radiationTypeName;
    
    /**
     * 特种作业
     */
    private Long  specialoperations;
    
    private String specialoperationsName;
    
    /**
     * 特殊作业
     */
    private Long specialWork;
    
    private String specialWorkName;
    
    /**
     * 个人职业健康监护档案编号
     */
    private String fileNo;
    
    /**
     * 建档时间
     */
    private Date filingTime;
    
    /**
     * 档案存放位置
     */
    private String filesStorageLocation;
    
    private String createBy;
	/**
	 * 嗜好
	 */
	private String habitSmoke;

	private Integer addFrom;

	/**
	 * 岗位属性：1：主岗位；2：兼职岗位
	 */
	private Byte workProperty;

	/**
	 * 档案是否已完成
	 */
	private String archivesFinished;

    /**
     * 最新体检时间
     */
    private Date latestCheckDate;
    
	/**
	 * 岗前体检时间，所有的体检时间（当前年份，最近1年，最近2年）
	 */
	private String gqCheckTimeInThisYear;
	private String gqCheckTimeInPastOneYear;
	private String gqCheckTimeInPastTwoYear;
	/**
	 * 在岗体检时间
	 */
	private String zgCheckTimeInThisYear;
	private String zgCheckTimeInPastOneYear;
	private String zgCheckTimeInPastTwoYear;
	/**
	 * 离岗体检时间
	 */
	private String lgCheckTimeInThisYear;
	private String lgCheckTimeInPastOneYear;
	private String lgCheckTimeInPastTwoYear;
    
    /**
     * 劳动者培训，岗前培训开始时间（当前年份，最近1年，最近2年）
     */
    private String gqStaffTrainThisYear;
    private String gqStaffTrainPastOneYear;
    private String gqStaffTrainPastTwoYear;
    /**
     * 岗中培训开始时间
     */
    private String gzStaffTrainThisYear;
    private String gzStaffTrainPastOneYear;
    private String gzStaffTrainPastTwoYear;
    
	/**
	 * 体检状态（岗前和岗中），已登记/-
	 */
	private String gqPhyCheckStatus;
	private String gzPhyCheckStatus;
	/**
	 * 劳动者培训状态（岗前和岗中），已登记/-
	 */
	private String gqStaffTrain;
	private String gzStaffTrain;

	/**
	 * 能否点击 未入职
	 */
	private Boolean isUnEmployee;

    /**
     * 岗位/工种，手动输入的字段
     */
    private String jobName;

	/**
	 * 最早体检时间
	 */
	private Date earliestCheckTime;

	public Date getEarliestCheckTime() {
		return earliestCheckTime;
	}

	public void setEarliestCheckTime(Date earliestCheckTime) {
		this.earliestCheckTime = earliestCheckTime;
	}

	public String getHabitSmoke() {
		return habitSmoke;
	}

	public void setHabitSmoke(String habitSmoke) {
		this.habitSmoke = habitSmoke;
	}

	public Date getBirthday() {
		return birthday;
	}
	public void setBirthday(Date birthday) {
		this.birthday = birthday;
	}
	public Integer getAge() {
		return age;
	}
	public void setAge(Integer age) {
		this.age = age;
	}
	public String getNativePlace() {
		return nativePlace;
	}
	public void setNativePlace(String nativePlace) {
		this.nativePlace = nativePlace;
	}
	public Byte getMarriage() {
		return marriage;
	}
	public void setMarriage(Byte marriage) {
		this.marriage = marriage;
	}
	public String getNation() {
		return nation;
	}
	public void setNation(String nation) {
		this.nation = nation;
	}
	public Long getEducation() {
		return education;
	}
	public void setEducation(Long education) {
		this.education = education;
	}
	public String getMajor() {
		return major;
	}
	public void setMajor(String major) {
		this.major = major;
	}
	public String getPhoneNo() {
		return phoneNo;
	}
	public void setPhoneNo(String phoneNo) {
		this.phoneNo = phoneNo;
	}
	public String getEmail() {
		return email;
	}
	public void setEmail(String email) {
		this.email = email;
	}
	public Date getJoinTime() {
		return joinTime;
	}
	public void setJoinTime(Date joinTime) {
		this.joinTime = joinTime;
	}
	public Date getWorkTime() {
		return workTime;
	}
	public void setWorkTime(Date workTime) {
		this.workTime = workTime;
	}
	public String getJobTitle() {
		return jobTitle;
	}
	public void setJobTitle(String jobTitle) {
		this.jobTitle = jobTitle;
	}
	public String getPlurality() {
		return plurality;
	}
	public void setPlurality(String plurality) {
		this.plurality = plurality;
	}
	public Boolean getIsRadiation() {
		return isRadiation;
	}
	public void setIsRadiation(Boolean isRadiation) {
		this.isRadiation = isRadiation;
	}
	public Date getRadiationYear() {
		return radiationYear;
	}
	public void setRadiationYear(Date radiationYear) {
		this.radiationYear = radiationYear;
	}
	public Long getRadiationType() {
		return radiationType;
	}
	public void setRadiationType(Long radiationType) {
		this.radiationType = radiationType;
	}
	public Long getSpecialoperations() {
		return specialoperations;
	}
	public void setSpecialoperations(Long specialoperations) {
		this.specialoperations = specialoperations;
	}
	public Long getSpecialWork() {
		return specialWork;
	}
	public void setSpecialWork(Long specialWork) {
		this.specialWork = specialWork;
	}
	public String getFileNo() {
		return fileNo;
	}
	public void setFileNo(String fileNo) {
		this.fileNo = fileNo;
	}
	public Date getFilingTime() {
		return filingTime;
	}
	public void setFilingTime(Date filingTime) {
		this.filingTime = filingTime;
	}
	public String getFilesStorageLocation() {
		return filesStorageLocation;
	}
	public void setFilesStorageLocation(String filesStorageLocation) {
		this.filesStorageLocation = filesStorageLocation;
	}
	public String getWorkNo() {
		return workNo;
	}
	public void setWorkNo(String workNo) {
		this.workNo = workNo;
	}
	
	public String getSexName() {
		if (gender != null) {
          if(gender==StaffGenderEnum.MALE.getValue()){
        	  sexName=StaffGenderEnum.MALE.getName();
          }else if(gender==StaffGenderEnum.FEMALE.getValue()){
        	  sexName=StaffGenderEnum.FEMALE.getName();
          }else{
        	  sexName="未知";
          }
		}
		return sexName;
	}
	public void setSexName(String sexName) {
		
		this.sexName = sexName;
	}
	public String getOrgName() {
		return orgName;
	}
	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}
	public String getWorkName() {
		return workName;
	}
	public void setWorkName(String workName) {
		this.workName = workName;
	}
	public String getWorkStatusName() {
		if(workStatus!=null){
			if(workStatus==StaffWorkStatusEnum.ONWORKING.getValue()){
				workStatusName=StaffWorkStatusEnum.ONWORKING.getName();
			}else if(workStatus==StaffWorkStatusEnum.NOWORKED.getValue()){
				workStatusName=StaffWorkStatusEnum.NOWORKED.getName();
			}else if(workStatus==StaffWorkStatusEnum.FURLOUGH.getValue()){
				workStatusName=StaffWorkStatusEnum.FURLOUGH.getName();
			}else if(workStatus==StaffWorkStatusEnum.TRANSFER.getValue()){
				workStatusName=StaffWorkStatusEnum.TRANSFER.getName();
			}else{
				workStatusName="";
			}
		}
		
		return workStatusName;
	}
	public void setWorkStatusName(String workStatusName) {
		this.workStatusName = workStatusName;
	}
	public CompanyOrganization getOrg() {
		return org;
	}
	public void setOrg(CompanyOrganization org) {
		this.org = org;
	}
	public WorkRoleInfo getCurrentWork() {
		return currentWork;
	}
	public void setCurrentWork(WorkRoleInfo currentWork) {
		this.currentWork = currentWork;
	}
	public String getRealName() {
		return realName;
	}
	public void setRealName(String realName) {
		this.realName = realName;
	}
	public Integer getGender() {
		return gender;
	}
	public void setGender(Integer gender) {
		this.gender = gender;
	}
	public Long getOrgId() {
		return orgId;
	}
	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}
	public Long getWorkRoleId() {
		return workRoleId;
	}
	public void setWorkRoleId(Long workRoleId) {
		this.workRoleId = workRoleId;
	}
	public Byte getWorkStatus() {
		return workStatus;
	}
	public void setWorkStatus(Byte workStatus) {
		this.workStatus = workStatus;
	}
	public Date getUpdateDate() {
		return updateDate;
	}
	public void setUpdateDate(Date updateDate) {
		this.updateDate = updateDate;
	}
	public String getOtherCompany() {
		return otherCompany;
	}
	public void setOtherCompany(String otherCompany) {
		this.otherCompany = otherCompany;
	}
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	/**
	 * @return the idCard
	 */
	public String getIdCard() {
		return StringMixedUtil.mixedIDCard(idCard);
	}
	/**
	 * @param idCard the idCard to set
	 */
	public void setIdCard(String idCard) {
		this.idCard = idCard;
	}
	public String getIdCardNo() {
		return idCard;
	}
	public void setIdCardNo(String idCardNo) {
		this.idCardNo = idCardNo;
	}
	public String getEducationName() {
		return educationName;
	}
	public void setEducationName(String educationName) {
		this.educationName = educationName;
	}
	public String getRadiationTypeName() {
		return radiationTypeName;
	}
	public void setRadiationTypeName(String radiationTypeName) {
		this.radiationTypeName = radiationTypeName;
	}
	public String getSpecialoperationsName() {
		return specialoperationsName;
	}
	public void setSpecialoperationsName(String specialoperationsName) {
		this.specialoperationsName = specialoperationsName;
	}
	public String getSpecialWorkName() {
		return specialWorkName;
	}
	public void setSpecialWorkName(String specialWorkName) {
		this.specialWorkName = specialWorkName;
	}
	public Long getContractInformId() {
		return contractInformId;
	}
	public void setContractInformId(Long contractInformId) {
		this.contractInformId = contractInformId;
	}
	public String getMarriageName() {
		if(marriage==StaffMaritalStatusEnum.DISSOCIATON.getCode()) {
			return StaffMaritalStatusEnum.DISSOCIATON.getName();
		}else if(marriage==StaffMaritalStatusEnum.MARRIED.getCode()) {
			return StaffMaritalStatusEnum.MARRIED.getName();
		}else if(marriage==StaffMaritalStatusEnum.UNMARRIED.getCode()) {
			return StaffMaritalStatusEnum.UNMARRIED.getName();
		}else {
			return "";
		}
		
	}
	public void setMarriageName(String marriageName) {
		this.marriageName = marriageName;
	}
	public String getIsRadiationName() {
		if(isRadiation==null) {
			return "";
		}else if(isRadiation) {
			return "是";
		}else if(!isRadiation) {
			return "否";
		}else {
			return "";
		}
	}
	public void setIsRadiationName(String isRadiationName) {
		this.isRadiationName = isRadiationName;
	}
	public Date getCurrentWorkBeginTime() {
		return currentWorkBeginTime;
	}
	public void setCurrentWorkBeginTime(Date currentWorkBeginTime) {
		this.currentWorkBeginTime = currentWorkBeginTime;
	}

    public Date getFirstBeginTime() {
        return firstBeginTime;
    }

    public void setFirstBeginTime(Date firstBeginTime) {
        this.firstBeginTime = firstBeginTime;
    }

    public Date getCurrentWorkLeaveTime() {
		return currentWorkLeaveTime;
	}
	public void setCurrentWorkLeaveTime(Date currentWorkLeaveTime) {
		this.currentWorkLeaveTime = currentWorkLeaveTime;
	}
	public String getOutsourceName() {
		return outsourceName;
	}
	public void setOutsourceName(String outsourceName) {
		this.outsourceName = outsourceName;
	}
	public Byte getOutsource() {
		return outsource;
	}
	public void setOutsource(Byte outsource) {
		this.outsource = outsource;
	}
	public String getCreateBy() {
		return createBy;
	}
	public void setCreateBy(String createBy) {
		this.createBy = createBy;
	}

	public Integer getAddFrom() {
		return addFrom;
	}

	public void setAddFrom(Integer addFrom) {
		this.addFrom = addFrom;
	}

	public Byte getWorkProperty() {
		return workProperty;
	}

	public void setWorkProperty(Byte workProperty) {
		this.workProperty = workProperty;
	}

	public String getArchivesFinished() {
		return archivesFinished;
	}

	public void setArchivesFinished(String archivesFinished) {
		this.archivesFinished = archivesFinished;
	}

    public Date getLatestCheckDate() {
        return latestCheckDate;
    }

    public void setLatestCheckDate(Date latestCheckDate) {
        this.latestCheckDate = latestCheckDate;
    }

    public String getGqCheckTimeInThisYear() {
        return gqCheckTimeInThisYear;
    }

    public void setGqCheckTimeInThisYear(String gqCheckTimeInThisYear) {
        this.gqCheckTimeInThisYear = gqCheckTimeInThisYear;
    }

    public String getGqCheckTimeInPastOneYear() {
        return gqCheckTimeInPastOneYear;
    }

    public void setGqCheckTimeInPastOneYear(String gqCheckTimeInPastOneYear) {
        this.gqCheckTimeInPastOneYear = gqCheckTimeInPastOneYear;
    }

    public String getGqCheckTimeInPastTwoYear() {
        return gqCheckTimeInPastTwoYear;
    }

    public void setGqCheckTimeInPastTwoYear(String gqCheckTimeInPastTwoYear) {
        this.gqCheckTimeInPastTwoYear = gqCheckTimeInPastTwoYear;
    }

    public String getZgCheckTimeInThisYear() {
        return zgCheckTimeInThisYear;
    }

    public void setZgCheckTimeInThisYear(String zgCheckTimeInThisYear) {
        this.zgCheckTimeInThisYear = zgCheckTimeInThisYear;
    }

    public String getZgCheckTimeInPastOneYear() {
        return zgCheckTimeInPastOneYear;
    }

    public void setZgCheckTimeInPastOneYear(String zgCheckTimeInPastOneYear) {
        this.zgCheckTimeInPastOneYear = zgCheckTimeInPastOneYear;
    }

    public String getZgCheckTimeInPastTwoYear() {
        return zgCheckTimeInPastTwoYear;
    }

    public void setZgCheckTimeInPastTwoYear(String zgCheckTimeInPastTwoYear) {
        this.zgCheckTimeInPastTwoYear = zgCheckTimeInPastTwoYear;
    }

    public String getLgCheckTimeInThisYear() {
        return lgCheckTimeInThisYear;
    }

    public void setLgCheckTimeInThisYear(String lgCheckTimeInThisYear) {
        this.lgCheckTimeInThisYear = lgCheckTimeInThisYear;
    }

    public String getLgCheckTimeInPastOneYear() {
        return lgCheckTimeInPastOneYear;
    }

    public void setLgCheckTimeInPastOneYear(String lgCheckTimeInPastOneYear) {
        this.lgCheckTimeInPastOneYear = lgCheckTimeInPastOneYear;
    }

    public String getLgCheckTimeInPastTwoYear() {
        return lgCheckTimeInPastTwoYear;
    }

    public void setLgCheckTimeInPastTwoYear(String lgCheckTimeInPastTwoYear) {
        this.lgCheckTimeInPastTwoYear = lgCheckTimeInPastTwoYear;
    }

    public String getGqStaffTrainThisYear() {
        return gqStaffTrainThisYear;
    }

    public void setGqStaffTrainThisYear(String gqStaffTrainThisYear) {
        this.gqStaffTrainThisYear = gqStaffTrainThisYear;
    }

    public String getGqStaffTrainPastOneYear() {
        return gqStaffTrainPastOneYear;
    }

    public void setGqStaffTrainPastOneYear(String gqStaffTrainPastOneYear) {
        this.gqStaffTrainPastOneYear = gqStaffTrainPastOneYear;
    }

    public String getGqStaffTrainPastTwoYear() {
        return gqStaffTrainPastTwoYear;
    }

    public void setGqStaffTrainPastTwoYear(String gqStaffTrainPastTwoYear) {
        this.gqStaffTrainPastTwoYear = gqStaffTrainPastTwoYear;
    }

    public String getGzStaffTrainThisYear() {
        return gzStaffTrainThisYear;
    }

    public void setGzStaffTrainThisYear(String gzStaffTrainThisYear) {
        this.gzStaffTrainThisYear = gzStaffTrainThisYear;
    }

    public String getGzStaffTrainPastOneYear() {
        return gzStaffTrainPastOneYear;
    }

    public void setGzStaffTrainPastOneYear(String gzStaffTrainPastOneYear) {
        this.gzStaffTrainPastOneYear = gzStaffTrainPastOneYear;
    }

    public String getGzStaffTrainPastTwoYear() {
        return gzStaffTrainPastTwoYear;
    }

    public void setGzStaffTrainPastTwoYear(String gzStaffTrainPastTwoYear) {
        this.gzStaffTrainPastTwoYear = gzStaffTrainPastTwoYear;
    }

    public String getGqPhyCheckStatus() {
		return gqPhyCheckStatus;
	}

	public void setGqPhyCheckStatus(String gqPhyCheckStatus) {
		this.gqPhyCheckStatus = gqPhyCheckStatus;
	}

	public String getGzPhyCheckStatus() {
		return gzPhyCheckStatus;
	}

	public void setGzPhyCheckStatus(String gzPhyCheckStatus) {
		this.gzPhyCheckStatus = gzPhyCheckStatus;
	}

	public String getGqStaffTrain() {
		return gqStaffTrain;
	}

	public void setGqStaffTrain(String gqStaffTrain) {
		this.gqStaffTrain = gqStaffTrain;
	}

	public String getGzStaffTrain() {
		return gzStaffTrain;
	}

	public void setGzStaffTrain(String gzStaffTrain) {
		this.gzStaffTrain = gzStaffTrain;
	}

	public Boolean getIsUnEmployee() {
		return isUnEmployee;
	}

	public void setIsUnEmployee(Boolean isUnEmployee) {
		this.isUnEmployee = isUnEmployee;
	}

    public String getJobName() {
        return jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }
}
