package cn.smarthse.modules.health.entity.base.staff;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Table(name = "staff_physiological_feature")
public class StaffPhysiologicalFeature implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * staff表id
     */
    @Column(name = "staff_id")
    private Long staffId;

    /**
     * 身高(cm)
     */
    private BigDecimal height;

    /**
     * 体重(kg)
     */
    private BigDecimal weight;

    /**
     * 胸围(cm)
     */
    private BigDecimal bust;

    /**
     * 腰围(cm)
     */
    private BigDecimal waist;

    /**
     * 臀围(cm)
     */
    private BigDecimal hips;

    /**
     * 鞋码(mm)
     */
    private BigDecimal shoe;

    /**
     * 工作服码
     */
    private String clothes;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取staff表id
     *
     * @return staff_id - staff表id
     */
    public Long getStaffId() {
        return staffId;
    }

    /**
     * 设置staff表id
     *
     * @param staffId staff表id
     */
    public void setStaffId(Long staffId) {
        this.staffId = staffId;
    }

    /**
     * 获取身高(cm)
     *
     * @return height - 身高(cm)
     */
    public BigDecimal getHeight() {
        return height;
    }

    /**
     * 设置身高(cm)
     *
     * @param height 身高(cm)
     */
    public void setHeight(BigDecimal height) {
        this.height = height;
    }

    /**
     * 获取体重(kg)
     *
     * @return weight - 体重(kg)
     */
    public BigDecimal getWeight() {
        return weight;
    }

    /**
     * 设置体重(kg)
     *
     * @param weight 体重(kg)
     */
    public void setWeight(BigDecimal weight) {
        this.weight = weight;
    }

    /**
     * 获取胸围(cm)
     *
     * @return bust - 胸围(cm)
     */
    public BigDecimal getBust() {
        return bust;
    }

    /**
     * 设置胸围(cm)
     *
     * @param bust 胸围(cm)
     */
    public void setBust(BigDecimal bust) {
        this.bust = bust;
    }

    /**
     * 获取腰围(cm)
     *
     * @return waist - 腰围(cm)
     */
    public BigDecimal getWaist() {
        return waist;
    }

    /**
     * 设置腰围(cm)
     *
     * @param waist 腰围(cm)
     */
    public void setWaist(BigDecimal waist) {
        this.waist = waist;
    }

    /**
     * 获取臀围(cm)
     *
     * @return hips - 臀围(cm)
     */
    public BigDecimal getHips() {
        return hips;
    }

    /**
     * 设置臀围(cm)
     *
     * @param hips 臀围(cm)
     */
    public void setHips(BigDecimal hips) {
        this.hips = hips;
    }

    /**
     * 获取鞋码(mm)
     *
     * @return shoe - 鞋码(mm)
     */
    public BigDecimal getShoe() {
        return shoe;
    }

    /**
     * 设置鞋码(mm)
     *
     * @param shoe 鞋码(mm)
     */
    public void setShoe(BigDecimal shoe) {
        this.shoe = shoe;
    }

    /**
     * 获取工作服码
     *
     * @return clothes - 工作服码
     */
    public String getClothes() {
        return clothes;
    }

    /**
     * 设置工作服码
     *
     * @param clothes 工作服码
     */
    public void setClothes(String clothes) {
        this.clothes = clothes == null ? null : clothes.trim();
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }
}