package cn.smarthse.modules.health.entity.base.staff;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

@Table(name = "staff_occupation_health")
public class StaffOccupationHealth implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 人员信息ID
     */
    @Column(name = "staff_id")
    private Long staffId;

    /**
     * 个人职业健康监护档案编号
     */
    @Column(name = "file_no")
    private String fileNo;

    /**
     * 档案存放位置
     */
    @Column(name = "files_storage_location")
    private String filesStorageLocation;

    /**
     * 档案负责人
     */
    @Column(name = "charge_staff_id")
    private Long chargeStaffId;

    /**
     * 建档时间
     */
    @Column(name = "filing_time")
    private Date filingTime;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取人员信息ID
     *
     * @return staff_id - 人员信息ID
     */
    public Long getStaffId() {
        return staffId;
    }

    /**
     * 设置人员信息ID
     *
     * @param staffId 人员信息ID
     */
    public void setStaffId(Long staffId) {
        this.staffId = staffId;
    }

    /**
     * 获取个人职业健康监护档案编号
     *
     * @return file_no - 个人职业健康监护档案编号
     */
    public String getFileNo() {
        return fileNo;
    }

    /**
     * 设置个人职业健康监护档案编号
     *
     * @param fileNo 个人职业健康监护档案编号
     */
    public void setFileNo(String fileNo) {
        this.fileNo = fileNo == null ? null : fileNo.trim();
    }

    /**
     * 获取档案存放位置
     *
     * @return files_storage_location - 档案存放位置
     */
    public String getFilesStorageLocation() {
        return filesStorageLocation;
    }

    /**
     * 设置档案存放位置
     *
     * @param filesStorageLocation 档案存放位置
     */
    public void setFilesStorageLocation(String filesStorageLocation) {
        this.filesStorageLocation = filesStorageLocation == null ? null : filesStorageLocation.trim();
    }

    /**
     * 获取档案负责人
     *
     * @return charge_staff_id - 档案负责人
     */
    public Long getChargeStaffId() {
        return chargeStaffId;
    }

    /**
     * 设置档案负责人
     *
     * @param chargeStaffId 档案负责人
     */
    public void setChargeStaffId(Long chargeStaffId) {
        this.chargeStaffId = chargeStaffId;
    }

    /**
     * 获取建档时间
     *
     * @return filing_time - 建档时间
     */
    public Date getFilingTime() {
        return filingTime;
    }

    /**
     * 设置建档时间
     *
     * @param filingTime 建档时间
     */
    public void setFilingTime(Date filingTime) {
        this.filingTime = filingTime;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }
}