package cn.smarthse.modules.health.entity.base.staff;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 《》
 *
 *
 * @Project:  smarthse-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <人员搜索条件类>
 * @JDK version used:      <JDK1.7>
 * @author BinXu(徐斌) [784514607@qq.com]
 * @since 2017年7月1日-下午2:11:28
 */
public class StaffInfoSearchParam implements Serializable{

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;


	/**
	 * JqGrid插件查询类 用于分页
	 */
	private JqGridParam  jqGridParam;

	/**
	 * 搜索关键字
	 */
	private String searchKey;


    /**
     * 是否为劳务派遣人员
     */
    private  Boolean isThirdParty;

	/**
     * 是否已经添加个人档案
	 *
     */
    private  Boolean isAddPersonal;


    /**
     * 厂商编号
     */
    private  Long  cid;


    /**
     * 性别
     */
    private Long gender;

    /**
     * 岗位状态
     */
    private Byte  workStatus;


    /**
     * 岗位/工种
     */
    private Long workRoleInfoId;
    private List<Long> workRoleInfoIdList;


    /**
     * 是否为放射工作人员
     */
    private Boolean isRadiation;
	/**
	 * 个人档案是否完善。
	 */
    private Boolean staffArchiveFinished;

    /**
     * 特种作业
     */
    private Long specialOperations;

    /**
     * 特殊作业（参见gbz188）
     */
    private Long specialWork;


    /**
     * organization的id（组织部门）
     */
    private Long orgId;


    private List<Long> orgIds=new ArrayList<>();

    /**
     * stafffId列表
     */
    private List<Long> staffIds=new ArrayList<>();


    /**
     * 外协企业名称
     */
    private String otherCompanyName;


    /**
     * 更新时间开始时间
     */
    private  Date updateDateBegin;


    /**
     * 更新时间结束时间
     */
    private  Date updateDateEnd;

    /**
     * 进厂时间开始时间
     */
    private  Date joinTimeBegin;

    /**
     * 进厂时间结束时间
     */
    private  Date joinTimeEnd;

	/**
	 * 是否多岗位人员
	 */
	private Boolean  isMultWork;


	private Boolean  isNoWork;


    /**
     * 是否高级搜索
     */
    private Boolean  isSeniorSearch;

	/**
	 * 当前岗位上岗时间  上岗时间
	 */
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private  Date currentWorkBeginTime;
	/**
	 * 日期搜索的开始时间
	 */
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date searchBeginTime;
	/**
	 * 日期搜索的结束时间
	 */
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date searchEndTime;
	/**
	 * 查询个人档案是否完善时，使用到的人员id
	 */
	private List<Long> staffInfoIdList = new ArrayList<>();
	/**
	 * 劳动者培训（1-岗前未登记，2-岗中未登记）
	 */
	private Integer staffTrainStatus;

	private String staffName;

	/**
	 * 未做体检的人员  1-岗前 2-在岗 3-离岗
	 */
	private Byte noPhcPhyCheck;
    
    /**
     * 外包单位名称
     */
    private String outCompanyName;

	public Byte getNoPhcPhyCheck() {
		return noPhcPhyCheck;
	}

	public void setNoPhcPhyCheck(Byte noPhcPhyCheck) {
		this.noPhcPhyCheck = noPhcPhyCheck;
	}

	/**
	 * 年度体检情况（yearStatusPhy）字符串类型
	 * - 23年
	 *     - 存在岗前体检数据（101）
	 *     - 存在岗中体检数据（102）
	 *     - 存在离岗体检数据（103）
	 * - 24年
	 *     - 存在岗前体检数据（201）
	 *     - 存在岗中体检数据（202）
	 *     - 存在离岗体检数据（203）
	 * 若6个同时选中，则 yearStatusPhy 传入：101,102,103,201,202,203
	 */
	private String yearStatusPhy;

	/**
	 * yearStatusPhy逗号分隔的内容解析在列表yearStatusPhyList中
	 */
	private List<String> yearStatusPhyList;

	public String getYearStatusPhy() {
		return yearStatusPhy;
	}

	public void setYearStatusPhy(String yearStatusPhy) {
		this.yearStatusPhy = yearStatusPhy;
	}

	public List<String> getYearStatusPhyList() {
		return yearStatusPhyList;
	}

	public void setYearStatusPhyList(List<String> yearStatusPhyList) {
		this.yearStatusPhyList = yearStatusPhyList;
	}

	/**
     * 1:代表劳动派遣 2：代表外包(当isThirdParty是true的时候使用)
     */
    private Byte outsource;

    /**
     * 是否是新版合规
     */
    private Boolean newCompliance;

    public Boolean getNewCompliance() {
        return newCompliance;
    }

    public void setNewCompliance(Boolean newCompliance) {
        this.newCompliance = newCompliance;
    }

	public String getSearchKey() {
		return searchKey;
	}


	public void setSearchKey(String searchKey) {
		this.searchKey = searchKey;
	}


	public Boolean getIsThirdParty() {
		return isThirdParty;
	}


	public void setIsThirdParty(Boolean isThirdParty) {
		this.isThirdParty = isThirdParty;
	}


	public Long getCid() {
		return cid;
	}


	public void setCid(Long cid) {
		this.cid = cid;
	}


	public Long getGender() {
		return gender;
	}


	public void setGender(Long gender) {
		this.gender = gender;
	}


	public Byte getWorkStatus() {
		return workStatus;
	}


	public void setWorkStatus(Byte workStatus) {
		this.workStatus = workStatus;
	}


	public Long getWorkRoleInfoId() {
		return workRoleInfoId;
	}


	public void setWorkRoleInfoId(Long workRoleInfoId) {
		this.workRoleInfoId = workRoleInfoId;
	}

    public List<Long> getWorkRoleInfoIdList() {
        return workRoleInfoIdList;
    }

    public void setWorkRoleInfoIdList(List<Long> workRoleInfoIdList) {
        this.workRoleInfoIdList = workRoleInfoIdList;
    }

    public Boolean getIsRadiation() {
		return isRadiation;
	}


	public void setIsRadiation(Boolean isRadiation) {
		this.isRadiation = isRadiation;
	}


	public Long getSpecialOperations() {
		return specialOperations;
	}


	public void setSpecialOperations(Long specialOperations) {
		this.specialOperations = specialOperations;
	}


	public Long getSpecialWork() {
		return specialWork;
	}


	public void setSpecialWork(Long specialWork) {
		this.specialWork = specialWork;
	}


	public Long getOrgId() {
		return orgId;
	}


	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}


	public String getOtherCompanyName() {
		return otherCompanyName;
	}


	public void setOtherCompanyName(String otherCompanyName) {
		this.otherCompanyName = otherCompanyName;
	}


	public Date getUpdateDateBegin() {
		return updateDateBegin;
	}


	public void setUpdateDateBegin(Date updateDateBegin) {
		this.updateDateBegin = updateDateBegin;
	}


	public Date getUpdateDateEnd() {
		return updateDateEnd;
	}


	public void setUpdateDateEnd(Date updateDateEnd) {
		this.updateDateEnd = updateDateEnd;
	}


	public Date getJoinTimeBegin() {
		return joinTimeBegin;
	}


	public void setJoinTimeBegin(Date joinTimeBegin) {
		this.joinTimeBegin = joinTimeBegin;
	}


	public Date getJoinTimeEnd() {
		return joinTimeEnd;
	}


	public void setJoinTimeEnd(Date joinTimeEnd) {
		this.joinTimeEnd = joinTimeEnd;
	}


	public Boolean getIsSeniorSearch() {
		return isSeniorSearch;
	}


	public void setIsSeniorSearch(Boolean isSeniorSearch) {
		this.isSeniorSearch = isSeniorSearch;
	}


	public JqGridParam getJqGridParam() {
		return jqGridParam;
	}


	public void setJqGridParam(JqGridParam jqGridParam) {
		this.jqGridParam = jqGridParam;
	}


	public Byte getOutsource() {
		return outsource;
	}


	public void setOutsource(Byte outsource) {
		this.outsource = outsource;
	}


	public List<Long> getOrgIds() {
		return orgIds;
	}


	public void setOrgIds(List<Long> orgIds) {
		this.orgIds = orgIds;
	}


	public List<Long> getStaffIds() {
		return staffIds;
	}


	public void setStaffIds(List<Long> staffIds) {
		this.staffIds = staffIds;
	}


	public Boolean getIsMultWork() {
		return isMultWork;
	}

	public void setIsMultWork(Boolean ismultWork) {
		this.isMultWork = ismultWork;
	}

	public Boolean getIsNoWork() {
		return isNoWork;
	}

	public void setIsNoWork(Boolean isNoWork) {
		this.isNoWork = isNoWork;
	}

	public Boolean getIsAddPersonal() {
		return isAddPersonal;
	}

	public void setIsAddPersonal(Boolean isAddPersonal) {
		this.isAddPersonal = isAddPersonal;
	}

	public Date getCurrentWorkBeginTime() {
		return currentWorkBeginTime;
	}

	public void setCurrentWorkBeginTime(Date currentWorkBeginTime) {
		this.currentWorkBeginTime = currentWorkBeginTime;
	}

	public Date getSearchBeginTime() {
		return searchBeginTime;
	}

	public void setSearchBeginTime(Date searchBeginTime) {
		this.searchBeginTime = searchBeginTime;
	}

	public Date getSearchEndTime() {
		return searchEndTime;
	}

	public void setSearchEndTime(Date searchEndTime) {
		this.searchEndTime = searchEndTime;
	}

	public Boolean getStaffArchiveFinished() {
		return staffArchiveFinished;
	}

	public void setStaffArchiveFinished(Boolean staffArchiveFinished) {
		this.staffArchiveFinished = staffArchiveFinished;
	}

	public List<Long> getStaffInfoIdList() {
		return staffInfoIdList;
	}

	public void setStaffInfoIdList(List<Long> staffInfoIdList) {
		this.staffInfoIdList = staffInfoIdList;
	}

	public Integer getStaffTrainStatus() {
		return staffTrainStatus;
	}

	public void setStaffTrainStatus(Integer staffTrainStatus) {
		this.staffTrainStatus = staffTrainStatus;
	}

	public String getStaffName() {
		return staffName;
	}

	public void setStaffName(String staffName) {
		this.staffName = staffName;
	}
    
    public String getOutCompanyName() {
        return outCompanyName;
    }

    public void setOutCompanyName(String outCompanyName) {
        this.outCompanyName = outCompanyName;
    }
}
