package cn.smarthse.modules.health.entity.base.staff;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;



@Table(name = "staff_info")
public class StaffInfo implements Serializable {



	/**
	 * 在人员选择（多选）界面上在待选区是否被选中
	 */
	@Transient
	private Boolean isSelected;
    @Transient
    private String idCard;
    /**
     * 档案6id
     */
    @Transient
    private Long personalArchiveId;
    @Transient
    private String creditCode;

    public Long getPersonalArchiveId() {
        return personalArchiveId;
    }

    public void setPersonalArchiveId(Long personalArchiveId) {
        this.personalArchiveId = personalArchiveId;
    }

    public String getCreditCode() {
        return creditCode;
    }

    public void setCreditCode(String creditCode) {
        this.creditCode = creditCode;
    }

    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }

    /**
	 * 是否为新入职的员工(0否1是)
	 */
	@Column(name="is_new_staff")
	private Boolean isNewStaff;

	/**
	 * 人员相关职业卫生信息
	 */
	@Transient
	private StaffOccupationHealth staffOccupationHealth;

	/**
	 * 人员相附件
	 */
	@Transient
    private List<StaffAttachment>  staffAttachments;



	/**
	 * 厂外工作经历
	 */
	@Transient
	private List<StaffWorkRole> outsideStaffWorkRoles;

	/**
	 * 厂内工作经历
	 */
	@Transient
	private List<StaffWorkRole>  localStaffWorkRoles;

	/**
	 * 岗位基本信息
	 */
	@Transient
	private StaffBasicWork staffBasicWork;

	/**
	 * 当前岗位具体信息
	 */
	@Transient
	private  StaffWorkRole  staffWorkRole;

	/**
	 *  人员生理特征信息表
	 */
	@Transient
	private StaffPhysiologicalFeature  staffPhysiologicalFeature;

	/**
	 * 人员基础信息一个人员对应一条有效基础信息
	 */
	@Transient
	private StaffBasicInfo  staffBasicInfo;

    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * staff_basic_info表的id
     */
    @Column(name = "staff_basic_id")
    private Long staffBasicId;

    /**
     * user表的id
     * <li>20170703在User表加入staffId,使之关系变的更加清晰,处理简单
     */
    @Deprecated
    @Column(name = "user_id")
    private Long userId;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 厂外企业名称
     */
    @Column(name = "other_company")
    private String otherCompany;

    /**
     * 0：本企业 1：第三方企业
     */
    @Column(name = "is_third_party")
    private Boolean isThirdParty;

    /**
     * 组织机构编码，完整的表示该组织的上下级关系（v1.3用于数据权限）
     */
    @Column(name = "org_code")
    private String orgCode;

    /**
     * 体检情况0未体检2已体检 1无需体检
     */
    @Column(name = "check_status")
    private Byte checkStatus;

    /**
     * 教育培训情况0未培训2已培训1无需培训
     */
    @Column(name = "train_status")
    private Byte trainStatus;

    /**
     * 合同告知情况:0未告知2已告知1无需告知
     */
    @Column(name = "inform_status")
    private Byte informStatus;

    /**
     * 岗位变动情况1上岗5转岗2离岗 4复岗（见枚举NoInformStaffChangeWorkStatusEnum）
     */
    @Column(name = "change_work_status")
    private Byte changeWorkStatus;

    /**
     * 休假开始时间
     */
    @Column(name = "furlough_begin_time")
    private Date furloughBeginTime;

    /**
     * 休假结束时间
     */
    @Column(name = "furlough_end_time")
    private Date furloughEndTime;

    /**
     * 休假状态  （0-未休假 1-正在休假  2-结束休假)
     */
    @Column(name = "furlough_status")
    private Byte furloughStatus;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    @Column(name = "org_id")
    private Long orgId;


    /**
     * 1:代表劳动派遣 2：代表外包(当isThirdParty是true的时候使用)
     */
    @Column(name = "outsource")
    private Byte outsource;


    /**
     * 离岗时是否领取了职业卫生档案复印件 1:是 2：否
     */
    @Column(name = "print_status")
    private Byte printStatus;

    /**
     * 新增路径 StaffAddFromEnum
     */
    @Column(name = "add_from")
    private Integer addFrom;

    /**
     * 岗位状态改变记录(见枚举)
     */
    @Column(name = "work_change_status_record")
    private Byte workChangeStatusRecord;
    /**
     * 培训系统用户id
     */
    @Column(name = "train_user_id")
    private Long trainUserId;

    /**
     * 数据来源（1 万达仓)
     */
    @Column(name = "data_source")
    private Byte dataSource;

    /**
     * 数据修改来源（1 万达仓)
     */
    @Column(name = "data_update_source")
    private Byte dataUpdateSource;

    @Transient
    private Integer localFSWorkNum;
    @Transient
    private Integer outFSWorkNum;
    @Transient
    private Integer localWorkNum;
    @Transient
    private Integer outWorkNum;
    @Transient
    private Integer completedNum;//个人档案已完成数量

    /**
     * 总的接害劳动者数（本企+外企）
     */
    @Transient
    private String localOutWorkStaffIds;
    /**
     * 总的接害人员身份证id
     */
    @Transient
    private String workStaffIdCards;

    @Transient
    private Integer totalWorkNum;

    @Transient
    private String staffName;
    /**
     * 执行删除的人员
     */
    @Transient
    private Long operateId;
    @Transient
    private String operateUser;
    /**
     * 人员删除原因
     */
    @Column(name = "delete_reason")
    private String deleteReason;
    /**
     * 最近一次岗前体检时间
     */
    @Transient
    private Date gqCheckTime;
    /**
     * 最近一次在岗体检时间
     */
    @Transient
    private Date zgCheckTime;
    /**
     * 离岗体检时间
     */
    @Transient
    private Date lgCheckTime;
    /**
     * 最早的体检时间
     */
    @Transient
    private Date earliestCheckTime;
    /**
     * 最新的体检时间
     */
    @Transient
    private Date latestCheckDate;
    /**
     * 车间部门
     */
    @Transient
    private String orgName;
    /**
     * 岗位工种
     */
    @Transient
    private String workName;
    /**
     * 档案是否已完成
     */
    @Transient
    private String archivesFinished;
    /**
     * 体检状态（岗前和岗中），已登记/-
     */
    @Transient
    private String gqPhyCheckStatus;
    @Transient
    private String gzPhyCheckStatus;
    /**
     * 劳动者培训状态（岗前和岗中），已登记/-
     */
    @Transient
    private String gqStaffTrain;
    @Transient
    private String gzStaffTrain;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取staff_basic_info表的id
     *
     * @return staff_basic_id - staff_basic_info表的id
     */
    public Long getStaffBasicId() {
        return staffBasicId;
    }

    /**
     * 设置staff_basic_info表的id
     *
     * @param staffBasicId staff_basic_info表的id
     */
    public void setStaffBasicId(Long staffBasicId) {
        this.staffBasicId = staffBasicId;
    }

    /**
     * 获取user表的id
     *
     * @return user_id - user表的id
     */
    @Deprecated
    public Long getUserId() {
        return userId;
    }

    /**
     * 设置user表的id
     *
     * @param userId user表的id
     */
    @Deprecated
    public void setUserId(Long userId) {
        this.userId = userId;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取厂外企业名称
     *
     * @return other_company - 厂外企业名称
     */
    public String getOtherCompany() {
        return otherCompany;
    }

    /**
     * 设置厂外企业名称
     *
     * @param otherCompany 厂外企业名称
     */
    public void setOtherCompany(String otherCompany) {
        this.otherCompany = otherCompany == null ? null : otherCompany.trim();
    }

    /**
     * 获取0：本企业 1：第三方企业
     *
     * @return is_third_party - 0：本企业 1：第三方企业
     */
    public Boolean getIsThirdParty() {
        return isThirdParty;
    }

    /**
     * 设置0：本企业 1：第三方企业
     *
     * @param isThirdParty 0：本企业 1：第三方企业
     */
    public void setIsThirdParty(Boolean isThirdParty) {
        this.isThirdParty = isThirdParty;
    }

    /**
     * 获取组织机构编码，完整的表示该组织的上下级关系（v1.3用于数据权限）
     *
     * @return org_code - 组织机构编码，完整的表示该组织的上下级关系（v1.3用于数据权限）
     */
    public String getOrgCode() {
        return orgCode;
    }

    /**
     * 设置组织机构编码，完整的表示该组织的上下级关系（v1.3用于数据权限）
     *
     * @param orgCode 组织机构编码，完整的表示该组织的上下级关系（v1.3用于数据权限）
     */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode == null ? null : orgCode.trim();
    }

    /**
     * 获取体检情况0未体检2已体检 1无需体检
     *
     * @return check_status - 体检情况0未体检2已体检 1无需体检
     */
    public Byte getCheckStatus() {
        return checkStatus;
    }

    /**
     * 设置体检情况0未体检2已体检 1无需体检
     *
     * @param checkStatus 体检情况0未体检2已体检 1无需体检
     */
    public void setCheckStatus(Byte checkStatus) {
        this.checkStatus = checkStatus;
    }

    /**
     * 获取教育培训情况0未培训2已培训1无需培训
     *
     * @return train_status - 教育培训情况0未培训2已培训1无需培训
     */
    public Byte getTrainStatus() {
        return trainStatus;
    }

    /**
     * 设置教育培训情况0未培训2已培训1无需培训
     *
     * @param trainStatus 教育培训情况0未培训2已培训1无需培训
     */
    public void setTrainStatus(Byte trainStatus) {
        this.trainStatus = trainStatus;
    }

    /**
     * 获取合同告知情况:0未告知2已告知1无需告知
     *
     * @return inform_status - 合同告知情况:0未告知2已告知1无需告知
     */
    public Byte getInformStatus() {
        return informStatus;
    }

    /**
     * 设置合同告知情况:0未告知2已告知1无需告知
     *
     * @param informStatus 合同告知情况:0未告知2已告知1无需告知
     */
    public void setInformStatus(Byte informStatus) {
        this.informStatus = informStatus;
    }

    /**
     * 获取岗位变动情况1上岗5转岗2离岗 4复岗
     *
     * @return change_work_status - 岗位变动情况1上岗5转岗2离岗 4复岗
     */
    public Byte getChangeWorkStatus() {
        return changeWorkStatus;
    }

    /**
     * 设置岗位变动情况1上岗5转岗2离岗 4复岗
     *
     * @param changeWorkStatus 岗位变动情况1上岗5转岗2离岗 4复岗
     */
    public void setChangeWorkStatus(Byte changeWorkStatus) {
        this.changeWorkStatus = changeWorkStatus;
    }

    /**
     * 获取休假开始时间
     *
     * @return furlough_begin_time - 休假开始时间
     */
    public Date getFurloughBeginTime() {
        return furloughBeginTime;
    }

    /**
     * 设置休假开始时间
     *
     * @param furloughBeginTime 休假开始时间
     */
    public void setFurloughBeginTime(Date furloughBeginTime) {
        this.furloughBeginTime = furloughBeginTime;
    }

    /**
     * 获取休假结束时间
     *
     * @return furlough_end_time - 休假结束时间
     */
    public Date getFurloughEndTime() {
        return furloughEndTime;
    }

    /**
     * 设置休假结束时间
     *
     * @param furloughEndTime 休假结束时间
     */
    public void setFurloughEndTime(Date furloughEndTime) {
        this.furloughEndTime = furloughEndTime;
    }

    /**
     * 获取休假状态  （0-未休假 1-正在休假  2-结束休假)
     *
     * @return furlough_status - 休假状态  （0-未休假 1-正在休假  2-结束休假)
     */
    public Byte getFurloughStatus() {
        return furloughStatus;
    }

    /**
     * 设置休假状态  （0-未休假 1-正在休假  2-结束休假)
     *
     * @param furloughStatus 休假状态  （0-未休假 1-正在休假  2-结束休假)
     */
    public void setFurloughStatus(Byte furloughStatus) {
        this.furloughStatus = furloughStatus;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

	public StaffBasicInfo getStaffBasicInfo() {
		return staffBasicInfo;
	}

	public void setStaffBasicInfo(StaffBasicInfo staffBasicInfo) {
		this.staffBasicInfo = staffBasicInfo;
	}

	public StaffPhysiologicalFeature getStaffPhysiologicalFeature() {
		return staffPhysiologicalFeature;
	}

	public void setStaffPhysiologicalFeature(StaffPhysiologicalFeature staffPhysiologicalFeature) {
		this.staffPhysiologicalFeature = staffPhysiologicalFeature;
	}

	public StaffBasicWork getStaffBasicWork() {
		return staffBasicWork;
	}

	public void setStaffBasicWork(StaffBasicWork staffBasicWork) {
		this.staffBasicWork = staffBasicWork;
	}

	public StaffWorkRole getStaffWorkRole() {
		return staffWorkRole;
	}

	public void setStaffWorkRole(StaffWorkRole staffWorkRole) {
		this.staffWorkRole = staffWorkRole;
	}

	public List<StaffWorkRole> getLocalStaffWorkRoles() {
		return localStaffWorkRoles;
	}

	public void setLocalStaffWorkRoles(List<StaffWorkRole> localStaffWorkRoles) {
		this.localStaffWorkRoles = localStaffWorkRoles;
	}

	public List<StaffWorkRole> getOutsideStaffWorkRoles() {
		return outsideStaffWorkRoles;
	}

	public void setOutsideStaffWorkRoles(List<StaffWorkRole> outsideStaffWorkRoles) {
		this.outsideStaffWorkRoles = outsideStaffWorkRoles;
	}



	public List<StaffAttachment> getStaffAttachments() {
		return staffAttachments;
	}

	public void setStaffAttachments(List<StaffAttachment> staffAttachments) {
		this.staffAttachments = staffAttachments;
	}

	public StaffOccupationHealth getStaffOccupationHealth() {
		return staffOccupationHealth;
	}

	public void setStaffOccupationHealth(StaffOccupationHealth staffOccupationHealth) {
		this.staffOccupationHealth = staffOccupationHealth;
	}

	public Boolean getIsNewStaff() {
		return isNewStaff;
	}

	public void setIsNewStaff(Boolean isNewStaff) {
		this.isNewStaff = isNewStaff;
	}

	public Byte getOutsource() {
		return outsource;
	}

	public void setOutsource(Byte outsource) {
		this.outsource = outsource;
	}

	public Byte getWorkChangeStatusRecord() {
		return workChangeStatusRecord;
	}

	public void setWorkChangeStatusRecord(Byte workChangeStatusRecord) {
		this.workChangeStatusRecord = workChangeStatusRecord;
	}

	public Byte getPrintStatus() {
		return printStatus;
	}

	public void setPrintStatus(Byte printStatus) {
		this.printStatus = printStatus;
	}

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

    public Integer getAddFrom() {
        return addFrom;
    }

    public void setAddFrom(Integer addFrom) {
        this.addFrom = addFrom;
    }

	public Boolean getIsSelected() {
		return isSelected;
	}

	public void setIsSelected(Boolean isSelected) {
		this.isSelected = isSelected;
	}

    public Long getTrainUserId() {
        return trainUserId;
    }

    public void setTrainUserId(Long trainUserId) {
        this.trainUserId = trainUserId;
    }

    public Byte getDataSource() {
        return dataSource;
    }

    public void setDataSource(Byte dataSource) {
        this.dataSource = dataSource;
    }

    public Byte getDataUpdateSource() {
        return dataUpdateSource;
    }

    public void setDataUpdateSource(Byte dataUpdateSource) {
        this.dataUpdateSource = dataUpdateSource;
    }

    public Integer getLocalFSWorkNum() {
        return localFSWorkNum;
    }

    public void setLocalFSWorkNum(Integer localFSWorkNum) {
        this.localFSWorkNum = localFSWorkNum;
    }

    public Integer getOutFSWorkNum() {
        return outFSWorkNum;
    }

    public void setOutFSWorkNum(Integer outFSWorkNum) {
        this.outFSWorkNum = outFSWorkNum;
    }

    public Integer getLocalWorkNum() {
        return localWorkNum;
    }

    public void setLocalWorkNum(Integer localWorkNum) {
        this.localWorkNum = localWorkNum;
    }

    public Integer getOutWorkNum() {
        return outWorkNum;
    }

    public void setOutWorkNum(Integer outWorkNum) {
        this.outWorkNum = outWorkNum;
    }

    public String getLocalOutWorkStaffIds() {
        return localOutWorkStaffIds;
    }

    public void setLocalOutWorkStaffIds(String localOutWorkStaffIds) {
        this.localOutWorkStaffIds = localOutWorkStaffIds;
    }

    public Integer getCompletedNum() {
        return completedNum;
    }

    public void setCompletedNum(Integer completedNum) {
        this.completedNum = completedNum;
    }

    public String getWorkStaffIdCards() {
        return workStaffIdCards;
    }

    public void setWorkStaffIdCards(String workStaffIdCards) {
        this.workStaffIdCards = workStaffIdCards;
    }

    public Integer getTotalWorkNum() {
        return totalWorkNum;
    }

    public void setTotalWorkNum(Integer totalWorkNum) {
        this.totalWorkNum = totalWorkNum;
    }

    public String getStaffName() {
        return staffName;
    }

    public void setStaffName(String staffName) {
        this.staffName = staffName;
    }

    public Long getOperateId() {
        return operateId;
    }

    public void setOperateId(Long operateId) {
        this.operateId = operateId;
    }

    public String getOperateUser() {
        return operateUser;
    }

    public void setOperateUser(String operateUser) {
        this.operateUser = operateUser;
    }

    public String getDeleteReason() {
        return deleteReason;
    }

    public void setDeleteReason(String deleteReason) {
        this.deleteReason = deleteReason;
    }

    public Date getGqCheckTime() {
        return gqCheckTime;
    }

    public void setGqCheckTime(Date gqCheckTime) {
        this.gqCheckTime = gqCheckTime;
    }

    public Date getZgCheckTime() {
        return zgCheckTime;
    }

    public void setZgCheckTime(Date zgCheckTime) {
        this.zgCheckTime = zgCheckTime;
    }

    public Date getLgCheckTime() {
        return lgCheckTime;
    }

    public void setLgCheckTime(Date lgCheckTime) {
        this.lgCheckTime = lgCheckTime;
    }

    public Date getEarliestCheckTime() {
        return earliestCheckTime;
    }

    public void setEarliestCheckTime(Date earliestCheckTime) {
        this.earliestCheckTime = earliestCheckTime;
    }

    public Date getLatestCheckDate() {
        return latestCheckDate;
    }

    public void setLatestCheckDate(Date latestCheckDate) {
        this.latestCheckDate = latestCheckDate;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getWorkName() {
        return workName;
    }

    public void setWorkName(String workName) {
        this.workName = workName;
    }

    public String getArchivesFinished() {
        return archivesFinished;
    }

    public void setArchivesFinished(String archivesFinished) {
        this.archivesFinished = archivesFinished;
    }

    public String getGqPhyCheckStatus() {
        return gqPhyCheckStatus;
    }

    public void setGqPhyCheckStatus(String gqPhyCheckStatus) {
        this.gqPhyCheckStatus = gqPhyCheckStatus;
    }

    public String getGzPhyCheckStatus() {
        return gzPhyCheckStatus;
    }

    public void setGzPhyCheckStatus(String gzPhyCheckStatus) {
        this.gzPhyCheckStatus = gzPhyCheckStatus;
    }

    public String getGqStaffTrain() {
        return gqStaffTrain;
    }

    public void setGqStaffTrain(String gqStaffTrain) {
        this.gqStaffTrain = gqStaffTrain;
    }

    public String getGzStaffTrain() {
        return gzStaffTrain;
    }

    public void setGzStaffTrain(String gzStaffTrain) {
        this.gzStaffTrain = gzStaffTrain;
    }
}
