package cn.smarthse.modules.health.entity.base.staff;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

@Table(name = "staff_header_set")
public class StaffHeaderSet implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_third_company")
    private Boolean isThirdCompany;

    /**
     * 表头值见StaffListHeaderEnum
     */
    @Column(name = "header_value")
    private Integer headerValue;

    /**
     * 表头名
     */
    @Column(name = "header_name")
    private String headerName;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_select")
    private Boolean isSelect;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_third_company - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsThirdCompany() {
        return isThirdCompany;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isThirdCompany 是否有效（0-无效，1-有效）
     */
    public void setIsThirdCompany(Boolean isThirdCompany) {
        this.isThirdCompany = isThirdCompany;
    }

    /**
     * 获取表头值见StaffListHeaderEnum
     *
     * @return header_value - 表头值见StaffListHeaderEnum
     */
    public Integer getHeaderValue() {
        return headerValue;
    }

    /**
     * 设置表头值见StaffListHeaderEnum
     *
     * @param headerValue 表头值见StaffListHeaderEnum
     */
    public void setHeaderValue(Integer headerValue) {
        this.headerValue = headerValue;
    }

    /**
     * 获取表头名
     *
     * @return header_name - 表头名
     */
    public String getHeaderName() {
        return headerName;
    }

    /**
     * 设置表头名
     *
     * @param headerName 表头名
     */
    public void setHeaderName(String headerName) {
        this.headerName = headerName == null ? null : headerName.trim();
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_select - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsSelect() {
        return isSelect;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isSelect 是否有效（0-无效，1-有效）
     */
    public void setIsSelect(Boolean isSelect) {
        this.isSelect = isSelect;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }
}