package cn.smarthse.modules.health.entity.base.staff;

import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.io.Serializable;
import java.util.Date;

/**
 * @ClassName StaffFieldChangeLog
 * @Description TODO$
 * @Author 曾华川
 * @Date 2024年06月27日 16:50
 **/
@Table(name = "staff_field_change_log")
@Data
public class StaffFieldChangeLog implements Serializable {

    private static final long serialVersionUID = -4092215905666293648L;
    @Id
    private Long id;

    @Column(name = "cid")
    private Long cid;

    @Column(name = "staff_id")
    private Long staffId;

    @Column(name = "before_info")
    private String beforeInfo;

    @Column(name = "after_info")
    private String afterInfo;

    /**
     * 变更的字段，枚举 StaffFieldChangeEnum
     */
    @Column(name = "field")
    private Integer field;

    @Column(name = "create_by")
    private Long createBy;

    @Column(name = "create_date")
    private Date createDate;

    @Column(name = "update_by")
    private Long updateBy;

    @Column(name = "update_date")
    private Date updateDate;

    @Column(name = "is_valid")
    private Boolean isValid;

    @Transient
    private Date changeTime;

    @Transient
    private String operator;

}
