package cn.smarthse.modules.health.entity.base.staff;

import cn.smarthse.modules.health.entity.base.company.CompanyOrganization;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Table(name = "staff_basic_work")
public class StaffBasicWork implements Serializable {

    private static final long serialVersionUID = 4235479365054488245L;

    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 人员信息ID
     */
    @Column(name = "staff_id")
    private Long staffId;

    /**
     * 工作时间
     */
    @Column(name = "work_time")
    private Date workTime;

    /**
     * 进厂时间
     */
    @Column(name = "join_time")
    private Date joinTime;

    /**
     * 工作编号
     */
    @Column(name = "work_no")
    private String workNo;

    /**
     * 职务
     */
    @Column(name = "job_title")
    private String jobTitle;

    /**
     * organization的id（组织部门）
     */
    @Column(name = "org_id")
    private Long orgId;

    /**
     * 特种作业
     */
    @Column(name = "special_operations")
    private Long specialOperations;

    /**
     * 特殊作业（参见gbz188）
     */
    @Column(name = "special_work")
    private Long specialWork;

    /**
     * 放射工作人员1true是0false否
     */
    @Column(name = "is_radiation")
    private Boolean isRadiation;

    /**
     * 职业照射的职业分类及其代码sysparam表的paramtype=12对应的paramcode
     */
    @Column(name = "radiation_type")
    private Long radiationType;
    /**
     * 职业照射的职业分类及其代码sysparam表的paramtype=12对应的paramcode   对应的 paramValue
     */
    @Transient
    private String radiationTypeName;
    /**
     * 起始从事放射工作时间
     */
    @Column(name = "radiation_year")
    private Date radiationYear;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;


    /**
     * 数据来源（1 万达仓)
     */
    @Column(name = "data_source")
    private Byte dataSource;

    /**
     * 数据修改来源（1 万达仓)
     */
    @Column(name = "data_update_source")
    private Byte dataUpdateSource;


    @Transient
    private StaffInfo staffInfo;

    /**
     * 组织实体
     */
    @Transient
    private CompanyOrganization companyOrganization;

    /**
     * 组织名字
     */
    @Transient
    private String orgName;

    /**
     * 兼职工作岗位
     */
    @Transient
    private List<StaffWorkRole> pluralityStaffWorkRoles;

    /**
     * 当前岗位信息
     */
    @Transient
    private StaffWorkRole currentStaffWorkRole;

    /**
     * 当前人员的基本信息
     */
    @Transient
    private StaffBasicInfo staffBasicInfo;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取人员信息ID
     *
     * @return staff_id - 人员信息ID
     */
    public Long getStaffId() {
        return staffId;
    }

    /**
     * 设置人员信息ID
     *
     * @param staffId 人员信息ID
     */
    public void setStaffId(Long staffId) {
        this.staffId = staffId;
    }

    /**
     * 获取工作时间
     *
     * @return work_time - 工作时间
     */
    public Date getWorkTime() {
        return workTime;
    }

    /**
     * 设置工作时间
     *
     * @param workTime 工作时间
     */
    public void setWorkTime(Date workTime) {
        this.workTime = workTime;
    }

    /**
     * 获取进厂时间
     *
     * @return join_time - 进厂时间
     */
    public Date getJoinTime() {
        return joinTime;
    }

    /**
     * 设置进厂时间
     *
     * @param joinTime 进厂时间
     */
    public void setJoinTime(Date joinTime) {
        this.joinTime = joinTime;
    }

    /**
     * 获取工作编号
     *
     * @return work_no - 工作编号
     */
    public String getWorkNo() {
        return workNo;
    }

    /**
     * 设置工作编号
     *
     * @param workNo 工作编号
     */
    public void setWorkNo(String workNo) {
        this.workNo = workNo == null ? null : workNo.trim();
    }

    /**
     * 获取职务
     *
     * @return job_title - 职务
     */
    public String getJobTitle() {
        return jobTitle;
    }

    /**
     * 设置职务
     *
     * @param jobTitle 职务
     */
    public void setJobTitle(String jobTitle) {
        this.jobTitle = jobTitle == null ? null : jobTitle.trim();
    }

    /**
     * 获取organization的id（组织部门）
     *
     * @return org_id - organization的id（组织部门）
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 设置organization的id（组织部门）
     *
     * @param orgId organization的id（组织部门）
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    /**
     * 获取特种作业
     *
     * @return special_operations - 特种作业
     */
    public Long getSpecialOperations() {
        return specialOperations;
    }

    /**
     * 设置特种作业
     *
     * @param specialOperations 特种作业
     */
    public void setSpecialOperations(Long specialOperations) {
        this.specialOperations = specialOperations;
    }

    /**
     * 获取特殊作业（参见gbz188）
     *
     * @return special_work - 特殊作业（参见gbz188）
     */
    public Long getSpecialWork() {
        return specialWork;
    }

    /**
     * 设置特殊作业（参见gbz188）
     *
     * @param specialWork 特殊作业（参见gbz188）
     */
    public void setSpecialWork(Long specialWork) {
        this.specialWork = specialWork;
    }

    /**
     * 获取放射工作人员1true是0false否
     *
     * @return is_radiation - 放射工作人员1true是0false否
     */
    public Boolean getIsRadiation() {
        return isRadiation;
    }

    /**
     * 设置放射工作人员1true是0false否
     *
     * @param isRadiation 放射工作人员1true是0false否
     */
    public void setIsRadiation(Boolean isRadiation) {
        this.isRadiation = isRadiation;
    }

    /**
     * 获取职业照射的职业分类及其代码sysparam表的paramtype=12对应的paramcode
     *
     * @return radiation_type - 职业照射的职业分类及其代码sysparam表的paramtype=12对应的paramcode
     */
    public Long getRadiationType() {
        return radiationType;
    }

    /**
     * 设置职业照射的职业分类及其代码sysparam表的paramtype=12对应的paramcode
     *
     * @param radiationType 职业照射的职业分类及其代码sysparam表的paramtype=12对应的paramcode
     */
    public void setRadiationType(Long radiationType) {
        this.radiationType = radiationType;
    }

    /**
     * 获取起始从事放射工作时间
     *
     * @return radiation_year - 起始从事放射工作时间
     */
    public Date getRadiationYear() {
        return radiationYear;
    }

    /**
     * 设置起始从事放射工作时间
     *
     * @param radiationYear 起始从事放射工作时间
     */
    public void setRadiationYear(Date radiationYear) {
        this.radiationYear = radiationYear;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public StaffBasicInfo getStaffBasicInfo() {
        return staffBasicInfo;
    }

    public void setStaffBasicInfo(StaffBasicInfo staffBasicInfo) {
        this.staffBasicInfo = staffBasicInfo;
    }

    public StaffWorkRole getCurrentStaffWorkRole() {
        return currentStaffWorkRole;
    }

    public void setCurrentStaffWorkRole(StaffWorkRole currentStaffWorkRole) {
        this.currentStaffWorkRole = currentStaffWorkRole;
    }

    public List<StaffWorkRole> getPluralityStaffWorkRoles() {
        return pluralityStaffWorkRoles;
    }

    public void setPluralityStaffWorkRoles(List<StaffWorkRole> pluralityStaffWorkRoles) {
        this.pluralityStaffWorkRoles = pluralityStaffWorkRoles;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public CompanyOrganization getCompanyOrganization() {
        return companyOrganization;
    }

    public void setCompanyOrganization(CompanyOrganization companyOrganization) {
        this.companyOrganization = companyOrganization;
    }

    public StaffInfo getStaffInfo() {
        return staffInfo;
    }

    public void setStaffInfo(StaffInfo staffInfo) {
        this.staffInfo = staffInfo;
    }

    public String getRadiationTypeName() {
        return radiationTypeName;
    }

    public void setRadiationTypeName(String radiationTypeName) {
        this.radiationTypeName = radiationTypeName;
    }

    public Byte getDataSource() {
        return dataSource;
    }

    public void setDataSource(Byte dataSource) {
        this.dataSource = dataSource;
    }

    public Byte getDataUpdateSource() {
        return dataUpdateSource;
    }

    public void setDataUpdateSource(Byte dataUpdateSource) {
        this.dataUpdateSource = dataUpdateSource;
    }
}