package cn.smarthse.modules.health.entity.base.staff;

import cn.smarthse.common.util.StringMixedUtil;
import cn.smarthse.common.util.sensitive.SensitiveInfo;
import cn.smarthse.common.util.sensitive.SensitiveType;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Table(name = "staff_basic_info")
public class StaffBasicInfo implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 姓名
     */
    @SensitiveInfo(type = SensitiveType.USER_NAME)
    @Column(name = "real_name")
    private String realName;

    /**
     * 性别 0:女 1：男
     */
    private Byte gender;

    /**
     * 民族
     */
    private String nation;

    /**
     * 身份证号
     */
    @SensitiveInfo(type = SensitiveType.ID_CARD)
    @Column(name = "id_card")
    private String idCard;

    /**
     * 加了密的身份号
     */
    @Transient
    private String idCardNo;

    /**
     * 生日
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date birthday;

    /**
     * 年龄
     */
    private Integer age;

    /**
     * 籍贯
     */
    @Column(name = "native_place")
    private String nativePlace;

    /**
     * 地址
     */
    private String address;

    /**
     * 婚姻状况0：未婚 1已婚
     */
    @Column(name = "is_married")
    private Boolean isMarried;

    /**
     * 婚姻状况见枚举StaffMaritalStatusEnum
     */
    @Column(name = "marital_status")
    private Byte maritalStatus;

    /**
     * 学历
     */
    private Long education;

    /**
     * 专业
     */
    private String major;

    /**
     * 固定电话
     */
    private String phone;

    /**
     * 手机号码
     */
    @SensitiveInfo(type = SensitiveType.PHONE)
    private String mobile;

    /**
     * 职业
     */
    private String profession;

    /**
     * 宗教
     */
    private String religion;

    /**
     * 政治面貌
     */
    @Column(name = "political_type")
    private String politicalType;

    /**
     * 兵役
     */
    @Column(name = "military_service")
    private String militaryService;

    /**
     * 血型
     */
    @Column(name = "blood_type")
    private String bloodType;

    /**
     * 所在区域id(sys_area.id)
     */
    @Column(name = "area_id")
    private Long areaId;

    /**
     * 头像文件id(file.id)
     */
    @Column(name = "face_id")
    private Long faceId;

    /**
     * 电子邮件
     */
    private String email;

    /**
     * 嗜好
     */
    @Column(name = "habit_smoke")
    private String habitSmoke;

    /**
     * 饮酒习惯
     */
    @Column(name = "habit_drink")
    private String habitDrink;

    /**
     * 睡眠习惯
     */
    @Column(name = "habit_sleep")
    private String habitSleep;

    /**
     * 通讯地址
     */
    @Column(name = "contact_address")
    private String contactAddress;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 数据来源（1 万达仓)
     */
    @Column(name = "data_source")
    private Byte dataSource;

    /**
     * 数据修改来源（1 万达仓)
     */
    @Column(name = "data_update_source")
    private Byte dataUpdateSource;

    /**
     * 岗位/工种，手动输入的字段
     */
    @Column
    private String jobName;

    @Column
    private String idcardType;

    @Transient
    private SysFileModel fileModel;

    private static final long serialVersionUID = 1L;

    public String getIdcardType() {
        return idcardType;
    }

    public void setIdcardType(String idcardType) {
        this.idcardType = idcardType;
    }

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取姓名
     *
     * @return real_name - 姓名
     */
    public String getRealName() {
        return realName;
    }

    /**
     * 设置姓名
     *
     * @param realName 姓名
     */
    public void setRealName(String realName) {
        this.realName = realName == null ? null : realName.trim();
    }

    /**
     * 获取性别 0:女 1：男
     *
     * @return gender - 性别 0:女 1：男
     */
    public Byte getGender() {
        return gender;
    }

    /**
     * 设置性别 0:女 1：男
     *
     * @param gender 性别 0:女 1：男
     */
    public void setGender(Byte gender) {
        this.gender = gender;
    }

    /**
     * 获取民族
     *
     * @return nation - 民族
     */
    public String getNation() {
        return nation;
    }

    /**
     * 设置民族
     *
     * @param nation 民族
     */
    public void setNation(String nation) {
        this.nation = nation == null ? null : nation.trim();
    }

    /**
     * 获取身份证号
     *
     * @return id_card - 身份证号
     */
    public String getIdCard() {
        return idCard;
    }

    /**
     * 设置身份证号
     *
     * @param idCard 身份证号
     */
    public void setIdCard(String idCard) {
        this.idCard = idCard == null ? null : idCard.trim();
    }

    /**
     * 获取生日
     *
     * @return birthday - 生日
     */
    public Date getBirthday() {
        return birthday;
    }

    /**
     * 设置生日
     *
     * @param birthday 生日
     */
    public void setBirthday(Date birthday) {
        this.birthday = birthday;
    }

    /**
     * 获取年龄
     *
     * @return age - 年龄
     */
    public Integer getAge() {
        return age;
    }

    /**
     * 设置年龄
     *
     * @param age 年龄
     */
    public void setAge(Integer age) {
        this.age = age;
    }

    /**
     * 获取籍贯
     *
     * @return native_place - 籍贯
     */
    public String getNativePlace() {
        return nativePlace;
    }

    /**
     * 设置籍贯
     *
     * @param nativePlace 籍贯
     */
    public void setNativePlace(String nativePlace) {
        this.nativePlace = nativePlace == null ? null : nativePlace.trim();
    }

    /**
     * 获取地址
     *
     * @return address - 地址
     */
    public String getAddress() {
        return address;
    }

    /**
     * 设置地址
     *
     * @param address 地址
     */
    public void setAddress(String address) {
        this.address = address == null ? null : address.trim();
    }

    /**
     * 获取婚姻状况0：未婚 1已婚
     *
     * @return is_married - 婚姻状况0：未婚 1已婚
     */
    public Boolean getIsMarried() {
        return isMarried;
    }

    /**
     * 设置婚姻状况0：未婚 1已婚
     *
     * @param isMarried 婚姻状况0：未婚 1已婚
     */
    public void setIsMarried(Boolean isMarried) {
        this.isMarried = isMarried;
    }

    /**
     * 获取学历
     *
     * @return education - 学历
     */
    public Long getEducation() {
        return education;
    }

    /**
     * 设置学历
     *
     * @param education 学历
     */
    public void setEducation(Long education) {
        this.education = education;
    }

    /**
     * 获取专业
     *
     * @return major - 专业
     */
    public String getMajor() {
        return major;
    }

    /**
     * 设置专业
     *
     * @param major 专业
     */
    public void setMajor(String major) {
        this.major = major == null ? null : major.trim();
    }

    /**
     * 获取固定电话
     *
     * @return phone - 固定电话
     */
    public String getPhone() {
        return phone;
    }

    /**
     * 设置固定电话
     *
     * @param phone 固定电话
     */
    public void setPhone(String phone) {
        this.phone = phone == null ? null : phone.trim();
    }

    /**
     * 获取手机号码
     *
     * @return mobile - 手机号码
     */
    public String getMobile() {
        return mobile;
    }

    /**
     * 设置手机号码
     *
     * @param mobile 手机号码
     */
    public void setMobile(String mobile) {
        this.mobile = mobile == null ? null : mobile.trim();
    }

    /**
     * 获取职业
     *
     * @return profession - 职业
     */
    public String getProfession() {
        return profession;
    }

    /**
     * 设置职业
     *
     * @param profession 职业
     */
    public void setProfession(String profession) {
        this.profession = profession == null ? null : profession.trim();
    }

    /**
     * 获取宗教
     *
     * @return religion - 宗教
     */
    public String getReligion() {
        return religion;
    }

    /**
     * 设置宗教
     *
     * @param religion 宗教
     */
    public void setReligion(String religion) {
        this.religion = religion == null ? null : religion.trim();
    }

    /**
     * 获取政治面貌
     *
     * @return political_type - 政治面貌
     */
    public String getPoliticalType() {
        return politicalType;
    }

    /**
     * 设置政治面貌
     *
     * @param politicalType 政治面貌
     */
    public void setPoliticalType(String politicalType) {
        this.politicalType = politicalType == null ? null : politicalType.trim();
    }

    /**
     * 获取兵役
     *
     * @return military_service - 兵役
     */
    public String getMilitaryService() {
        return militaryService;
    }

    /**
     * 设置兵役
     *
     * @param militaryService 兵役
     */
    public void setMilitaryService(String militaryService) {
        this.militaryService = militaryService == null ? null : militaryService.trim();
    }

    /**
     * 获取血型
     *
     * @return blood_type - 血型
     */
    public String getBloodType() {
        return bloodType;
    }

    /**
     * 设置血型
     *
     * @param bloodType 血型
     */
    public void setBloodType(String bloodType) {
        this.bloodType = bloodType == null ? null : bloodType.trim();
    }

    /**
     * 获取所在区域id(sys_area.id)
     *
     * @return area_id - 所在区域id(sys_area.id)
     */
    public Long getAreaId() {
        return areaId;
    }

    /**
     * 设置所在区域id(sys_area.id)
     *
     * @param areaId 所在区域id(sys_area.id)
     */
    public void setAreaId(Long areaId) {
        this.areaId = areaId;
    }

    /**
     * 获取头像文件id(file.id)
     *
     * @return face_id - 头像文件id(file.id)
     */
    public Long getFaceId() {
        return faceId;
    }

    /**
     * 设置头像文件id(file.id)
     *
     * @param faceId 头像文件id(file.id)
     */
    public void setFaceId(Long faceId) {
        this.faceId = faceId;
    }

    /**
     * 获取电子邮件
     *
     * @return email - 电子邮件
     */
    public String getEmail() {
        return email;
    }

    /**
     * 设置电子邮件
     *
     * @param email 电子邮件
     */
    public void setEmail(String email) {
        this.email = email == null ? null : email.trim();
    }

    /**
     * 获取抽烟习惯
     *
     * @return habit_smoke - 抽烟习惯
     */
    public String getHabitSmoke() {
        return habitSmoke;
    }

    /**
     * 设置抽烟习惯
     *
     * @param habitSmoke 抽烟习惯
     */
    public void setHabitSmoke(String habitSmoke) {
        this.habitSmoke = habitSmoke == null ? null : habitSmoke.trim();
    }

    /**
     * 获取饮酒习惯
     *
     * @return habit_drink - 饮酒习惯
     */
    public String getHabitDrink() {
        return habitDrink;
    }

    /**
     * 设置饮酒习惯
     *
     * @param habitDrink 饮酒习惯
     */
    public void setHabitDrink(String habitDrink) {
        this.habitDrink = habitDrink == null ? null : habitDrink.trim();
    }

    /**
     * 获取睡眠习惯
     *
     * @return habit_sleep - 睡眠习惯
     */
    public String getHabitSleep() {
        return habitSleep;
    }

    /**
     * 设置睡眠习惯
     *
     * @param habitSleep 睡眠习惯
     */
    public void setHabitSleep(String habitSleep) {
        this.habitSleep = habitSleep == null ? null : habitSleep.trim();
    }

    /**
     * 获取通讯地址
     *
     * @return contact_address - 通讯地址
     */
    public String getContactAddress() {
        return contactAddress;
    }

    /**
     * 设置通讯地址
     *
     * @param contactAddress 通讯地址
     */
    public void setContactAddress(String contactAddress) {
        this.contactAddress = contactAddress == null ? null : contactAddress.trim();
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }


    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

	public Byte getMaritalStatus() {
		return maritalStatus;
	}

	public void setMaritalStatus(Byte maritalStatus) {
		this.maritalStatus = maritalStatus;
	}

	public String getIdCardNo() {
		return StringMixedUtil.mixedIDCard(idCard);
	}

	public void setIdCardNo(String idCardNo) {
		this.idCardNo = idCardNo;
	}

    public Byte getDataSource() {
        return dataSource;
    }

    public void setDataSource(Byte dataSource) {
        this.dataSource = dataSource;
    }

    public Byte getDataUpdateSource() {
        return dataUpdateSource;
    }

    public void setDataUpdateSource(Byte dataUpdateSource) {
        this.dataUpdateSource = dataUpdateSource;
    }

    public String getJobName() {
        return jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public SysFileModel getFileModel() {
        return fileModel;
    }

    public void setFileModel(SysFileModel fileModel) {
        this.fileModel = fileModel;
    }
}
