package cn.smarthse.modules.health.entity.base.selfjudge.vo;

import cn.smarthse.modules.health.entity.base.selfjudge.*;
import cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluate;
import cn.smarthse.services.hfi.api.model.riskev.EvDataStatModel;
import cn.smarthse.services.hfi.api.model.riskev.EvFactorTouchNum;
import cn.smarthse.services.hfi.api.pojo.vo.riskev.RiskDecisionVo;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Data
public class SelfInspectionRiskAssessmentReportV314Vo implements Serializable{

    private Long id;

    private Long cid;

    private Date  judgeReportDate; //自查及评估日期

    private Integer judgeLevel; //职业健康管理状况等级
    private Integer judgeStatus;

    private String   judgeLevelName;  //职业健康管理状况等级

    private Integer riskLevel; //职业病危害暴露风险等级 1:低风险2:中风险3:高风险

    private String riskLevelName; //职业病危害暴露风险等级 1:低风险2:中风险3:高风险

    private Integer riskClassify; //职业病危害综合风险类别 1:甲类2:乙类3:丙类

    private String riskClassifyName; //职业病危害综合风险类别 1:甲类2:乙类3:丙类

    private Long operatorStaffId;//操作人

    private String operatorStaffName;//操作人

    private Long thirdOrgId; //机构id

    private String thirdOrgName; //机构名称

    private Byte status;  //状态,1:存草稿 2:完成(待审核) 3:退回(被退回待提交)  4:审核完成(待报送) 5:已报送  （3以后为v3131新增）

    private Byte dataSource; //数据来源,1:企业端 2:机构端

    private String reportStaff; //上报人

    private  String industryClassificationName;

    private  String economicTypeName;

    private Date updateDate;  //数据更新时间

    private String scaleName;

    private Integer year; //年份

    private Byte reportFromYear; //(类别)自查来自年份还是变更 1：年份 2：变更

    private Long exposureReportId; //职业病危害暴露风险等级的id

    private Long selfReportId; //职业卫生管理状况等级的id

    private Long changeFromId; //来自哪个id
    private Long childId; //下属的id

    /**
     * 自查人(评估人员)
     */

    private String selfStaffName;
    private String changeReason;

    /**
     * 自查时间(评估时间)
     */
    private Date selfTime;

    private SelfInspectionRiskAssessmentReportInfo reportInfo;

    /*
    * 自查表
    **/
    private  CompanyHsePreventionControlSelfJudge selfJudge;

    /**
    * 来自暴露风险评估-职业病危害因素
    */
    private List<EvDataStatModel>   evDataStatModels;

    private Map<String, List<EvFactorTouchNum>>  evDataStatModelsMap;


    /**
     * 职业病危害接触水平
     */
    private RiskDecisionVo riskDecisionVo;
    /** 
    * 暴露风险表
    **/
    private RiskExposeEvaluate  riskExposeEvaluate;

    private List<OccupationalSelfJudgeTermV308>  ableMissingTerms; //合理缺项

    private List<OccupationalSelfJudgeTermV308>  rectifyTerms; //待整改项

    


}