package cn.smarthse.modules.health.entity.base.selfjudge.vo;

import cn.smarthse.modules.health.entity.base.selfjudge.CompanyHseInvestigation;
import cn.smarthse.modules.health.entity.base.selfjudge.CompanyHseInvestigationRiskAssessmentInfo;
import cn.smarthse.modules.health.entity.base.selfjudge.CompanyHseRiskAssessment;
import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
public class CompanyHseInvestigationRiskAssessmentInfoVo implements Serializable {
    private Long id;

    private Long cid;

    private Date  reportDate; //评估时间

    private Integer riskLevel; //职业病危害暴露风险等级 1:低风险2:中风险3:高风险

    private String riskLevelName; //职业病危害暴露风险等级 1:低风险2:中风险3:高风险

    private Long operatorStaffId;//操作人

    private String operatorStaffName;//操作人

    private Long thirdOrgId; //机构id

    private String thirdOrgName; //机构名称

    private Byte status;  //状态,1:存草稿 2:完成 3:退回

    private Byte dataSource; //数据来源(分类),1:企业端(企业自查) 2:机构端(委托技术服务机构)

    private String reportStaff; //上报人(评估人)

    private static final long serialVersionUID = 1L;



    /*
     * @Comments:  <用人单位职业病危害暴露情况调查和风险评估表——职业病危害暴露情况调查 (存在多条)>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 下午4:02 2022/2/23
     **/
    private List<CompanyHseInvestigation> companyHseInvestigations;
    /*
     * @Comments:  <用人单位职业病危害暴露情况调查和风险评估表>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 下午4:03 2022/2/23
     **/
    private CompanyHseInvestigationRiskAssessmentInfo info;

    /*
     * @Comments:  <用人单位职业病危害暴露情况调查和风险评估表——风险评估>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @since 下午4:03 2022/2/23
     **/
    private CompanyHseRiskAssessment companyHseRiskAssessment;
}