package cn.smarthse.modules.health.entity.base.selfjudge;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

/**
 * self_inspection_risk_assessment_report_info
 * @author 
 */
@Table(name="self_inspection_risk_assessment_report_info")
public class SelfInspectionRiskAssessmentReportInfo implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * cid
     */
    private Long cid;

    /**
     * 企业名称
     */
    @Column(name = "company_name")
    private String companyName;

    /**
     * 统一社会信用代码
     */
    @Column(name = "uniform_social_credit_code")
    private String uniformSocialCreditCode;

    /**
     * 注册地址 areaId
     */
    @Column(name = "register_add_area_id")
    private Long registerAddAreaId;

    /**
     * 注册详细地址
     */
    @Column(name = "register_add_detail")
    private String registerAddDetail;

    /**
     * 工作场所地址 areaId
     */
    @Column(name = "location_add_area_id")
    private Long locationAddAreaId;

    /**
     * 工作场所详细地址
     */
    @Column(name = "location_add_detail")
    private String locationAddDetail;

    /**
     * 企业规模
     */
    @Column(name = "company_scale")
    private Long companyScale;


    /**
     * 唯一键
     */
    @Column(name = "cid_year")
    private String cidYear;

    /**
     * 行业分类
     */
    @Column(name = "industry_classification")
    private Long industryClassification;

    /**
     * 上属（或主管）单位
     */
    @Column(name = "superior_unit")
    private String superiorUnit;

    /**
     * 经济规模
     */
    @Column(name = "economic_type")
    private Long economicType;

    /**
     * 法定代表人
     */
    @Column(name = "legal_representative")
    private String legalRepresentative;

    /**
     * 联系电话
     */
    @Column(name = "contact_number")
    private String contactNumber;

    /**
     * 管理机构 （职业卫生管理机构 有数据：有；无数据：无）
     */
    @Column(name = "manage_org")
    private String manageOrg;

    /**
     * 职业卫生管理人数-专职
     */
    @Column(name = "manage_major_staff_count")
    private Long manageMajorStaffCount;

    /**
     * 职业卫生管理人数-兼职
     */
    @Column(name = "manage_plurality_staff_count")
    private Long managePluralityStaffCount;

    /**
     * 职业健康检查人数（含外委-上岗应检
     */
    @Column(name = "check_go_work_staff_count")
    private Long checkGoWorkStaffCount;

    /**
     * 职业健康检查人数（含外委-在岗应检
     */
    @Column(name = "check_on_work_staff_count")
    private Long checkOnWorkStaffCount;

    /**
     * 职业健康检查人数（含外委-离岗应检
     */
    @Column(name = "check_leave_work_staff_count")
    private Long checkLeaveWorkStaffCount;


    /**
     * 职业健康检查人数（含外委-上岗实检
     */
    @Column(name = "check_go_work_staff_real_count")
    private Long checkGoWorkStaffRealCount;

    /**
     * 职业健康检查人数（含外委-在岗实检
     */
    @Column(name = "check_on_work_staff_real_count")
    private Long checkOnWorkStaffRealCount;

    /**
     * 职业健康检查人数（含外委-离岗实检
     */
    @Column(name = "check_leave_work_staff_real_count")
    private Long checkLeaveWorkStaffRealCount;

    /**
     * 劳动者总人数（含外委）
     */
    @Column(name = "staff_count")
    private Long staffCount;

    /**
     * 接触职业病危害总人数（含外委）
     */
    @Column(name = "harm_staff_count")
    private Long harmStaffCount;

    /**
     * 职业病累计人数-目前在岗
     */
    @Column(name = "disease_on_work_staff_count")
    private Long diseaseOnWorkStaffCount;

    /**
     * 职业病累计人数-历年累计
     */
    @Column(name = "disease_staff_count")
    private Long diseaseStaffCount;

    /**
     * 机构id
     */
    @Column(name = "third_org_id")
    private Long thirdOrgId;

    /**
     * 机构名称(冗余)
     */
    @Column(name = "third_org_name")
    private String thirdOrgName;

    /**
     * 状态,1:存草稿 2:完成(待审核) 3:退回(被退回待提交)  4:审核完成(待报送) 5:已报送  （3以后为v3131新增）
     */
    @Column(name = "status")
    private Byte status;

    /**
     * 报告年份还是变更 1：年份 2：变更 （类型）
     */
    @Column(name = "report_from_year")
    private Byte reportFromYear;

    /**
     * 变更原因 1:暴露风险发生重大变化 2:职业卫生管理状况发生重大变化 (多选英文逗号隔开) 3.综合风险评估报告发生重大变化
     */
    @Column(name = "change_reason")
    private String changeReason;

    /**
     * 变更原因 详细说明（非必填）
     */
    @Column(name = "reason_detail")
    private String reasonDetail;

    /**
     * 数据来源,1:企业端 2:机构端
     */
    @Column(name = "data_source")
    private Byte dataSource;

    /**
     * 上报人
     */
    @Column(name = "report_staff")
    private String reportStaff;

    /**
     * 年份
     */
    private  Long year;

    /**
     * 自查人(评估人员)
     */
    @Column(name = "self_staff_name")
    private String selfStaffName;

    /**
     * 自查时间(评估时间)
     */
    @Column(name = "self_time")
    private Date selfTime;
    /**
     * 暴露风险评估报告id
     */
    @Column(name = "exposure_report_id")
    private Long exposureReportId;


    /**
     * 报告签字人
     */
    @Column(name = "report_sign_staff")
    private String reportSignStaff;


    /**
     * 暴露风险评估报告旧的id
     */
    @Column(name = "exposure_report_old_id")
    private Long exposureReportOldId;

    /**
     * 自查报告id
     */
    @Column(name = "self_report_id")
    private Long selfReportId;

    /**
     * 自查报告旧的id
     */
    @Column(name = "self_report_old_id")
    private Long  selfReportOldId;


    /**
     * 退回原因 1:防治责任自查审核不通过 2:暴露风险评估审核不通过,3:其他(多选英文逗号隔开)
     */
    @Column(name = "back_reason")
    private String backReason;

    /**
     * 退回原因 详细说明（非必填）
     */
    @Column(name = "back_reason_detail")
    private String backReasonDetail;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建者
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 上报时间（完成时间）
     */
    @Column(name = "report_date")
    private Date reportDate;

    /**
     * 最后修改者
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 手机号码
     */
    @Column(name = "phone_number")
    private String phoneNumber;

    /**
     * 变更来自哪个Id
     */
    @Column(name = "change_from_id")
    private Long  changeFromId;



    /**
     * 职业病危害综合风险类别 1:甲类2:乙类3:丙类(v314)
     */
    @Column(name = "risk_classify")
    private Long riskClassify;

    @Column(name = "source_id")
    private Long sourceId;

    /**
     * 标记类型，0原表，1副本表，2退回上报之后的历史数据表(退回时用)
     */
    @Column(name = "table_flag")
    private Byte tableFlag;

    /*
    * 操作人
    **/
    @Transient
    private String operator;



    private static final long serialVersionUID = 1L;

    public String getPhoneNumber() {
        return phoneNumber;
    }

    public String getOperator() {
        return operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getCid() {
        return cid;
    }

    public void setCid(Long cid) {
        this.cid = cid;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getUniformSocialCreditCode() {
        return uniformSocialCreditCode;
    }

    public void setUniformSocialCreditCode(String uniformSocialCreditCode) {
        this.uniformSocialCreditCode = uniformSocialCreditCode;
    }

    public String getBackReason() {
        return backReason;
    }

    public void setBackReason(String backReason) {
        this.backReason = backReason;
    }

    public String getBackReasonDetail() {
        return backReasonDetail;
    }

    public void setBackReasonDetail(String backReasonDetail) {
        this.backReasonDetail = backReasonDetail;
    }

    public Long getRegisterAddAreaId() {
        return registerAddAreaId;
    }

    public Long getRiskClassify() {
        return riskClassify;
    }

    public void setRiskClassify(Long riskClassify) {
        this.riskClassify = riskClassify;
    }

    public void setRegisterAddAreaId(Long registerAddAreaId) {
        this.registerAddAreaId = registerAddAreaId;
    }

    public String getRegisterAddDetail() {
        return registerAddDetail;
    }

    public void setRegisterAddDetail(String registerAddDetail) {
        this.registerAddDetail = registerAddDetail;
    }

    public Long getLocationAddAreaId() {
        return locationAddAreaId;
    }

    public void setLocationAddAreaId(Long locationAddAreaId) {
        this.locationAddAreaId = locationAddAreaId;
    }

    public String getLocationAddDetail() {
        return locationAddDetail;
    }

    public void setLocationAddDetail(String locationAddDetail) {
        this.locationAddDetail = locationAddDetail;
    }

    public Long getCompanyScale() {
        return companyScale;
    }

    public void setCompanyScale(Long companyScale) {
        this.companyScale = companyScale;
    }

    public Long getIndustryClassification() {
        return industryClassification;
    }

    public void setIndustryClassification(Long industryClassification) {
        this.industryClassification = industryClassification;
    }

    public String getSuperiorUnit() {
        return superiorUnit;
    }

    public void setSuperiorUnit(String superiorUnit) {
        this.superiorUnit = superiorUnit;
    }

    public Long getEconomicType() {
        return economicType;
    }

    public void setEconomicType(Long economicType) {
        this.economicType = economicType;
    }

    public String getLegalRepresentative() {
        return legalRepresentative;
    }

    public void setLegalRepresentative(String legalRepresentative) {
        this.legalRepresentative = legalRepresentative;
    }

    public String getContactNumber() {
        return contactNumber;
    }

    public void setContactNumber(String contactNumber) {
        this.contactNumber = contactNumber;
    }

    public String getManageOrg() {
        return manageOrg;
    }

    public void setManageOrg(String manageOrg) {
        this.manageOrg = manageOrg;
    }

    public Long getManageMajorStaffCount() {
        return manageMajorStaffCount;
    }

    public void setManageMajorStaffCount(Long manageMajorStaffCount) {
        this.manageMajorStaffCount = manageMajorStaffCount;
    }

    public Long getManagePluralityStaffCount() {
        return managePluralityStaffCount;
    }

    public void setManagePluralityStaffCount(Long managePluralityStaffCount) {
        this.managePluralityStaffCount = managePluralityStaffCount;
    }

    public Long getCheckGoWorkStaffCount() {
        return checkGoWorkStaffCount;
    }

    public void setCheckGoWorkStaffCount(Long checkGoWorkStaffCount) {
        this.checkGoWorkStaffCount = checkGoWorkStaffCount;
    }

    public Long getCheckOnWorkStaffCount() {
        return checkOnWorkStaffCount;
    }

    public void setCheckOnWorkStaffCount(Long checkOnWorkStaffCount) {
        this.checkOnWorkStaffCount = checkOnWorkStaffCount;
    }

    public Long getCheckLeaveWorkStaffCount() {
        return checkLeaveWorkStaffCount;
    }

    public void setCheckLeaveWorkStaffCount(Long checkLeaveWorkStaffCount) {
        this.checkLeaveWorkStaffCount = checkLeaveWorkStaffCount;
    }

    public Long getStaffCount() {
        return staffCount;
    }

    public void setStaffCount(Long staffCount) {
        this.staffCount = staffCount;
    }

    public Long getHarmStaffCount() {
        return harmStaffCount;
    }

    public void setHarmStaffCount(Long harmStaffCount) {
        this.harmStaffCount = harmStaffCount;
    }

    public Long getDiseaseOnWorkStaffCount() {
        return diseaseOnWorkStaffCount;
    }

    public void setDiseaseOnWorkStaffCount(Long diseaseOnWorkStaffCount) {
        this.diseaseOnWorkStaffCount = diseaseOnWorkStaffCount;
    }

    public Long getDiseaseStaffCount() {
        return diseaseStaffCount;
    }

    public void setDiseaseStaffCount(Long diseaseStaffCount) {
        this.diseaseStaffCount = diseaseStaffCount;
    }

    public Long getThirdOrgId() {
        return thirdOrgId;
    }

    public void setThirdOrgId(Long thirdOrgId) {
        this.thirdOrgId = thirdOrgId;
    }

    public String getThirdOrgName() {
        return thirdOrgName;
    }

    public void setThirdOrgName(String thirdOrgName) {
        this.thirdOrgName = thirdOrgName;
    }

    public Byte getStatus() {
        return status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public Byte getDataSource() {
        return dataSource;
    }

    public void setDataSource(Byte dataSource) {
        this.dataSource = dataSource;
    }

    public String getReportStaff() {
        return reportStaff;
    }

    public void setReportStaff(String reportStaff) {
        this.reportStaff = reportStaff;
    }

    public Boolean getIsValid() {
        return isValid;
    }

    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    public Long getCreateBy() {
        return createBy;
    }

    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Long getUpdateBy() {
        return updateBy;
    }

    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public Date getUpdateDate() {
        return updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public Date getReportDate() {
        return reportDate;
    }

    public void setReportDate(Date reportDate) {
        this.reportDate = reportDate;
    }

    public Long getYear() {
        return year;
    }

    public void setYear(Long year) {
        this.year = year;
    }

    public String getSelfStaffName() {
        return selfStaffName;
    }

    public void setSelfStaffName(String selfStaffName) {
        this.selfStaffName = selfStaffName;
    }

    public Date getSelfTime() {
        return selfTime;
    }

    public void setSelfTime(Date selfTime) {
        this.selfTime = selfTime;
    }

    public Long getExposureReportId() {
        return exposureReportId;
    }

    public void setExposureReportId(Long exposureReportId) {
        this.exposureReportId = exposureReportId;
    }

    public Long getSelfReportId() {
        return selfReportId;
    }

    public void setSelfReportId(Long selfReportId) {
        this.selfReportId = selfReportId;
    }

    public Byte getReportFromYear() {
        return reportFromYear;
    }

    public void setReportFromYear(Byte reportFromYear) {
        this.reportFromYear = reportFromYear;
    }

    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public String getReasonDetail() {
        return reasonDetail;
    }

    public void setReasonDetail(String reasonDetail) {
        this.reasonDetail = reasonDetail;
    }

    public Long getCheckGoWorkStaffRealCount() {
        return checkGoWorkStaffRealCount;
    }

    public void setCheckGoWorkStaffRealCount(Long checkGoWorkStaffRealCount) {
        this.checkGoWorkStaffRealCount = checkGoWorkStaffRealCount;
    }

    public Long getCheckOnWorkStaffRealCount() {
        return checkOnWorkStaffRealCount;
    }

    public void setCheckOnWorkStaffRealCount(Long checkOnWorkStaffRealCount) {
        this.checkOnWorkStaffRealCount = checkOnWorkStaffRealCount;
    }

    public Long getCheckLeaveWorkStaffRealCount() {
        return checkLeaveWorkStaffRealCount;
    }

    public void setCheckLeaveWorkStaffRealCount(Long checkLeaveWorkStaffRealCount) {
        this.checkLeaveWorkStaffRealCount = checkLeaveWorkStaffRealCount;
    }

    public String getReportSignStaff() {
        return reportSignStaff;
    }

    public void setReportSignStaff(String reportSignStaff) {
        this.reportSignStaff = reportSignStaff;
    }

    public Long getExposureReportOldId() {
        return exposureReportOldId;
    }

    public void setExposureReportOldId(Long exposureReportOldId) {
        this.exposureReportOldId = exposureReportOldId;
    }

    public Long getSelfReportOldId() {
        return selfReportOldId;
    }

    public void setSelfReportOldId(Long selfReportOldId) {
        this.selfReportOldId = selfReportOldId;
    }

    public Long getChangeFromId() {
        return changeFromId;
    }

    public void setChangeFromId(Long changeFromId) {
        this.changeFromId = changeFromId;
    }

    public String getCidYear() {
        return cidYear;
    }

    public void setCidYear(String cidYear) {
        this.cidYear = cidYear;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public Byte getTableFlag() {
        return tableFlag;
    }

    public void setTableFlag(Byte tableFlag) {
        this.tableFlag = tableFlag;
    }
}