package cn.smarthse.modules.health.entity.base.selfjudge;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * self_inspection_risk_assessment_report_harm_level
 * @author 
 */
@Table(name="self_inspection_risk_assessment_report_harm_level")
@Data
public class SelfInspectionRiskAssessmentReportHarmLevel implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 主表id
     */
    @Column(name = "info_id")
    private Long infoId;

    /**
     * 一般职业病危害因素-超标人数
     */
    @Column(name = "general_over_staff_count")
    private Long generalOverStaffCount;

    /**
     * 一般职业病危害因素-不超标人数
     */
    @Column(name = "general_not_over_staff_count")
    private Long generalNotOverStaffCount;

    /**
     * 严重职业病危害因素-超标人数
     */
    @Column(name = "serious_over_staff_count")
    private Long seriousOverStaffCount;

    /**
     * 严重职业病危害因素-不超标人数
     */
    @Column(name = "serious_not_over_staff_count")
    private Long seriousNotOverStaffCount;



    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建者
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改者
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    private static final long serialVersionUID = 1L;
}