package cn.smarthse.modules.health.entity.base.selfjudge;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;


/**
 * self_inspection_risk_assessment_report_harm_judge_info
 * @author 
 */
@Table(name="self_inspection_risk_assessment_report_harm_judge_info")
public class SelfInspectionRiskAssessmentReportHarmJudgeInfo implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 主表id
     */
    @Column(name = "info_id")
    private Long infoId;

    /**
     * occupational_self_judge_v308表id
     */
    @Column(name = "judge_id")
    private Long judgeId;

    /**
     * 职业病危害综合风险类别
     */
    @Transient
    private String judgeResultLevelName;


    @Transient
    private Byte judgeResultLevel;

    /**
     * 职业病危害暴露风险等级 1:低风险2:中风险3:高风险
     */
    @Column(name = "risk_level")
    private Long riskLevel;

    @Transient
    private String riskLevelName;

    /**
     * 职业病危害综合风险类别 1:甲类2:乙类3:丙类
     */
    @Column(name = "risk_classify")
    private Long riskClassify;

    @Transient
    private String riskClassifyName;

    /**
     * 情况概述
     */
    @Column(name = "situation_summary")
    private String situationSummary;

    /**
     * 发现问题
     */
    @Column(name = "find_question")
    private String findQuestion;

    /**
     * 整改概述
     */
    @Column(name = "rectification_summary")
    private String rectificationSummary;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建者
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改者
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    private static final long serialVersionUID = 1L;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getInfoId() {
        return infoId;
    }

    public void setInfoId(Long infoId) {
        this.infoId = infoId;
    }

    public Long getJudgeId() {
        return judgeId;
    }

    public void setJudgeId(Long judgeId) {
        this.judgeId = judgeId;
    }

    public Long getRiskLevel() {
        return riskLevel;
    }

    public void setRiskLevel(Long riskLevel) {
        this.riskLevel = riskLevel;
    }

    public Long getRiskClassify() {
        return riskClassify;
    }

    public void setRiskClassify(Long riskClassify) {
        this.riskClassify = riskClassify;
    }

    public String getSituationSummary() {
        return situationSummary;
    }

    public void setSituationSummary(String situationSummary) {
        this.situationSummary = situationSummary;
    }

    public String getFindQuestion() {
        return findQuestion;
    }

    public void setFindQuestion(String findQuestion) {
        this.findQuestion = findQuestion;
    }

    public String getRectificationSummary() {
        return rectificationSummary;
    }

    public void setRectificationSummary(String rectificationSummary) {
        this.rectificationSummary = rectificationSummary;
    }

    public Boolean getIsValid() {
        return isValid;
    }

    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    public Long getCreateBy() {
        return createBy;
    }

    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Long getUpdateBy() {
        return updateBy;
    }

    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public Date getUpdateDate() {
        return updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public String getRiskLevelName() {
        return riskLevelName;
    }

    public void setRiskLevelName(String riskLevelName) {
        this.riskLevelName = riskLevelName;
    }

    public String getRiskClassifyName() {
        return riskClassifyName;
    }

    public void setRiskClassifyName(String riskClassifyName) {
        this.riskClassifyName = riskClassifyName;
    }

    public String getJudgeResultLevelName() {
        return judgeResultLevelName;
    }

    public void setJudgeResultLevelName(String judgeResultLevelName) {
        this.judgeResultLevelName = judgeResultLevelName;
    }

    public Byte getJudgeResultLevel() {
        return judgeResultLevel;
    }

    public void setJudgeResultLevel(Byte judgeResultLevel) {
        this.judgeResultLevel = judgeResultLevel;
    }
}