package cn.smarthse.modules.health.entity.base.selfjudge;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import lombok.Data;

/**
 * self_inspection_risk_assessment_report_harm
 * @author 
 */
@Table(name="self_inspection_risk_assessment_report_harm")
@Data
public class SelfInspectionRiskAssessmentReportHarm implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 主表id
     */
    @Column(name = "info_id")
    private Long infoId;

    /**
     * 危害因素id
     */
    @Column(name = "harm_id")
    private Long harmId;

    /**
     * 危害因素名称
     */
    @Column(name = "harm_name")
    private String harmName;

    /**
     * 危害因素类型
     */
    @Column(name = "harm_type")
    private String harmType;

    /**
     * 接触人数
     */
    @Column(name = "staff_count")
    private Long staffCount;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建者
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改者
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    private static final long serialVersionUID = 1L;
}