package cn.smarthse.modules.health.entity.base.selfjudge;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Table(name = "occupational_self_judge_v308")
public class OccupationalSelfJudgeV308 implements Serializable {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    private Long cid;

    @Column(name = "judge_staff_org_id")
    private Long judgeStaffOrgId;

    @Column(name = "judge_staff_org_name")
    private String judgeStaffOrgName;

    @Column(name = "judge_status")
    private Byte judgeStatus;

    @Column(name = "result_level")
    private Byte resultLevel;

    @Column(name = "data_source")
    private Byte dataSource;

    @Column(name = "report_staff")
    private String reportStaff;

    @Column(name = "report_date")
    private Date reportDate;

    @Transient
    private List<OccupationalSelfJudgeTermV308> terms;

    @Column(name = "total_score")
    private Long totalScore;

    //self_inspection_risk_assessment_report_info表id
    @Column(name = "self_risk_report_info_id")
    private Long selfRiskReportInfoId;


    @Transient
    private String resultLevelName;

    @Transient
    private String companyName;

    @Transient
    private String registrant;

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getRegistrant() {
        return registrant;
    }

    public void setRegistrant(String registrant) {
        this.registrant = registrant;
    }

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    public List<OccupationalSelfJudgeTermV308> getTerms() {
        return terms;
    }

    public void setTerms(List<OccupationalSelfJudgeTermV308> terms) {
        this.terms = terms;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getCid() {
        return cid;
    }

    public void setCid(Long cid) {
        this.cid = cid;
    }

    public Long getJudgeStaffOrgId() {
        return judgeStaffOrgId;
    }

    public void setJudgeStaffOrgId(Long judgeStaffOrgId) {
        this.judgeStaffOrgId = judgeStaffOrgId;
    }

    public String getJudgeStaffOrgName() {
        return judgeStaffOrgName;
    }

    public void setJudgeStaffOrgName(String judgeStaffOrgName) {
        this.judgeStaffOrgName = judgeStaffOrgName == null ? null : judgeStaffOrgName.trim();
    }

    public Byte getJudgeStatus() {
        return judgeStatus;
    }

    public void setJudgeStatus(Byte judgeStatus) {
        this.judgeStatus = judgeStatus;
    }

    public Byte getResultLevel() {
        return resultLevel;
    }

    public void setResultLevel(Byte resultLevel) {
        this.resultLevel = resultLevel;
    }

    public Long getSelfRiskReportInfoId() {
        return selfRiskReportInfoId;
    }

    public void setSelfRiskReportInfoId(Long selfRiskReportInfoId) {
        this.selfRiskReportInfoId = selfRiskReportInfoId;
    }

    public Byte getDataSource() {
        return dataSource;
    }

    public void setDataSource(Byte dataSource) {
        this.dataSource = dataSource;
    }

    public String getReportStaff() {
        return reportStaff;
    }

    public void setReportStaff(String reportStaff) {
        this.reportStaff = reportStaff == null ? null : reportStaff.trim();
    }

    public Date getReportDate() {
        return reportDate;
    }

    public void setReportDate(Date reportDate) {
        this.reportDate = reportDate;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Long getCreateBy() {
        return createBy;
    }

    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    public Date getUpdateDate() {
        return updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public Long getUpdateBy() {
        return updateBy;
    }

    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public Boolean getIsValid() {
        return isValid;
    }

    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    public Long getTotalScore() {
        return totalScore;
    }

    public void setTotalScore(Long totalScore) {
        this.totalScore = totalScore;
    }

    public String getResultLevelName() {
        return resultLevelName;
    }

    public void setResultLevelName(String resultLevelName) {
        this.resultLevelName = resultLevelName;
    }
}