package cn.smarthse.modules.health.entity.base.selfjudge;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Table(name = "occupational_self_judge_term_v308")
public class OccupationalSelfJudgeTermV308  implements Serializable {
    @Id
//    @GeneratedValue(strategy = GenerationType.AUTO, generator = "select right(uuid_short(),19)")
    private Long id;

    @Column(name = "self_id")
    private Long selfId;

    @Column(name = "term_no")
    private Long termNo;

    @Transient
    private String termName;

    //当前前选项是否需要更新（用于更新每一项）
    @Transient
    private boolean isNeeUpdate=false;

    @Column(name = "term_score")
    private Double termScore;
    @Column(name = "term_obtain_score")
    private Double termObtainScore;

    //一致性,1:一致 2:不一致
    @Column(name = "term_uniformity")
    private Byte termUniformity;
   //检查结果,1:符合、2:基本符合、3:不符合,4:合理缺项
    @Column(name = "check_result")
    private Byte checkResult;

    //检查结果不能选中那些值 1:符合、2:基本符合、3:不符合,4:合理缺项
    @Transient
    private List<Integer> checkResultChangeable;

    /**
     * 选择了(3不符合或者2基本符合)为整改措施;选择了(4合理缺项)为合理缺项情况说明
     */
    private String  situation;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    @Transient
    private String checkResultName;

    /**
     * 是否检查（0未检查，1已检查）
     */
    @Column(name = "checked")
    private Boolean checked;


    /**
     * 移除的检查结果，通过英文逗号隔开
     */
    @Column(name = "remove_check_results")
    private String removeCheckResults;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getSelfId() {
        return selfId;
    }

    public void setSelfId(Long selfId) {
        this.selfId = selfId;
    }

    public Long getTermNo() {
        return termNo;
    }

    public void setTermNo(Long termNo) {
        this.termNo = termNo;
    }

    public Double getTermScore() {
        return termScore;
    }

    public void setTermScore(Double termScore) {
        this.termScore = termScore;
    }

    public Double getTermObtainScore() {
        return termObtainScore;
    }

    public void setTermObtainScore(Double termObtainScore) {
        this.termObtainScore = termObtainScore;
    }

    public Byte getTermUniformity() {
        return termUniformity;
    }

    public void setTermUniformity(Byte termUniformity) {
        this.termUniformity = termUniformity;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Long getCreateBy() {
        return createBy;
    }

    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    public Date getUpdateDate() {
        return updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public Long getUpdateBy() {
        return updateBy;
    }

    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public Boolean getIsValid() {
        return isValid;
    }

    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    public Byte getCheckResult() {
        return checkResult;
    }

    public void setCheckResult(Byte checkResult) {
        this.checkResult = checkResult;
    }

    public Boolean getChecked() {
        return checked;
    }

    public void setChecked(Boolean checked) {
        this.checked = checked;
    }

    public String getCheckResultName() {
        if(Byte.valueOf((byte) 1).equals(checkResult)){
            checkResultName="符合";
        }else if(Byte.valueOf((byte) 2).equals(checkResult)){
            checkResultName="基本符合";
        }else if(Byte.valueOf((byte) 3).equals(checkResult)){
            checkResultName="不符合";
        }else if(Byte.valueOf((byte) 4).equals(checkResult)){
            checkResultName="合理缺项";
        }else {
            checkResultName="";
        }
        return checkResultName;
    }

    public String getSituation() {
        return situation;
    }

    public void setSituation(String situation) {
        this.situation = situation;
    }

    public String getTermName() {
        return termName;
    }

    public void setTermName(String termName) {
        this.termName = termName;
    }

    public boolean getIsNeeUpdate() {
        return isNeeUpdate;
    }

    public void setIsNeeUpdate(boolean isNeeUpdate) {
        this.isNeeUpdate = isNeeUpdate;
    }

    public List<Integer> getCheckResultChangeable() {
        return checkResultChangeable;
    }

    public void setCheckResultChangeable(List<Integer> checkResultChangeable) {
        this.checkResultChangeable = checkResultChangeable;
    }
}