package cn.smarthse.modules.health.entity.base.selfjudge;

import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import java.io.Serializable;
import java.util.Date;

/**
 * @Project 职业健康 master
 * @Module 自我评定 selfjudge
 * @JDK_Vserion 1.8
 * @Author 邓力宾
 * @Email dlb@smarthse.cn
 * @since 19-6-6 上午11:50
 * @Desc 自我评定跳过记录表(occupational_self_judge_skip)对应的实体类
 */
public class OccupationalSelfJudgeSkip implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;
    /**
     * 企业ID
     */
    private Long cid;
    /**
     * 员工id
     */
    private Long judgeStaffInfoId;
    /**
     * 员工姓名
     */
    private String judgeStaffName;
    /**
     *创建时间
     */
    private Date createDate;
    /**
     *创建人员工id
     */
    private Long createBy;
    /**
     *最后修改时间
     */
    private Date updateDate;
    /**
     *最后修改人员工id
     */
    private Long updateBy;
    /**
     *是否有效 (软删)
     */
    private Boolean isValid;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getCid() {
        return cid;
    }

    public void setCid(Long cid) {
        this.cid = cid;
    }

    public Long getJudgeStaffInfoId() {
        return judgeStaffInfoId;
    }

    public void setJudgeStaffInfoId(Long judgeStaffInfoId) {
        this.judgeStaffInfoId = judgeStaffInfoId;
    }

    public String getJudgeStaffName() {
        return judgeStaffName;
    }

    public void setJudgeStaffName(String judgeStaffName) {
        this.judgeStaffName = judgeStaffName == null ? null : judgeStaffName.trim();
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Long getCreateBy() {
        return createBy;
    }

    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    public Date getUpdateDate() {
        return updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public Long getUpdateBy() {
        return updateBy;
    }

    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public Boolean getIsValid() {
        return isValid;
    }

    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }
}