package cn.smarthse.modules.health.entity.base.selfjudge;

import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;
/**
 * @Project 职业健康 master
 * @Module 自我评定 selfjudge
 * @JDK_Vserion 1.8
 * @Author 邓力宾
 * @Email dlb@smarthse.cn
 * @since 19-6-3 下午12:24
 * @Desc 自我评定记录表(occupational_self_judge_record)对应的实体类
 */
@Table(name = "occupational_self_judge_record")
public class OccupationalSelfJudgeRecord implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;
    /**
     * 企业ID
     */
    private Long cid;
    /**
     * 评定人员工id
     */
    private Long judgeStaffInfoId;

    /**
     * 评定人员工姓名
     */
    private String judgeStaffName;
    /**
     *业务状态,1:评定中 2:完成
     */
    private Byte judgeStatus;
    /**
     *评定结果等级,0:未评定 1:A级 2:B级 3:C级
     */
    private Byte resultLevel;
    /**
     *创建时间
     */
    private Date createDate;
    /**
     *创建人员工id
     */
    private Long createBy;
    /**
     *最后修改时间
     */
    private Date updateDate;
    /**
     *最后修改人员工id
     */
    private Long updateBy;
    /**
     *是否有效 (软删)
     */
    private Boolean isValid;
    /**
     *管理制度检查是否合格,-1:未判定 0:否 1:是
     */
    private Byte managerialSystem;
    /**
     *管理机构检查是否合格,-1:未判定 0:否 1:是
     * 否决项
     */
    private Byte managerialOrg;
    /**
     *管理人员检查是否合格,-1:未判定 0:否 1:是
     */
    private Byte managerialStaff;
    /**
     *危害检测检查是否合格,-1:未判定 0:否 1:是
     * 否决项
     */
    private Byte harmfulCheck;
    /**
     *现状评估检查是否合格,-1:未判定 0:否 1:是
     */
    private Byte situationEvaluation;
    /**
     *超标情况是否合格,-1:未判定 0:否 1:是
     */
    private Byte overProofSituation;
    /**
     *场所设置检查是否合格,-1:未判定 0:否 1:是
     */
    private Byte locationSetup;
    /**
     *合理布局检查是否合格,-1:未判定 0:否 1:是
     * 否决项
     */
    private Byte properRedistribution;
    /**
     *告知警示检查是否合格,-1:未判定 0:否 1:是
     */
    private Byte caution;
    /**
     *项目申报是否合格,-1:未判定 0:否 1:是
     * 否决项
     */
    private Byte projectApplication;
    /**
     *三同时检查是否合格,-1:未判定 0:否 1:是
     */
    private Byte threeSameTime;
    /**
     *合同告知检查是否合格,-1:未判定 0:否 1:是
     */
    private Byte contractImpart;
    /**
     *设施有效检查是否合格,-1:未判定 0:否 1:是
     */
    private Byte facilitiesEffective;
    /**
     *用品配备检查是否合格,-1:未判定 0:否 1:是
     */
    private Byte protectionArticle;
    /**
     *使用管理检查是否合格,-1:未判定 0:否 1:是
     */
    private Byte usingManagement;
    /**
     *负责人培训检查是否合格,-1:未判定 0:否 1:是
     */
    private Byte principalTraining;
    /**
     *劳动者培训检查是否合格,-1:未判定 0:否 1:是
     */
    private Byte workerTraining;
    /**
     *上岗离岗体检检查是否合格,-1:未判定 0:否 1:是
     */
    private Byte upOffGuardPhysicalExam;
    /**
     *在岗期间体检检查是否合格,-1:未判定 0:否 1:是
     * 否决项
     */
    private Byte onGuardPhysicalExam;
    /**
     *监护档案检查是否合格,-1:未判定 0:否 1:是
     */
    private Byte wardshipRecord;
    /**
     *职业病检查是否合格,-1:未判定 0:否 1:是
     * 否决项
     */
    private Byte occupationalDisease;
    /**
     *行政处罚检查是否合格,-1:未判定 0:否 1:是
     * 否决项
     */
    private Byte govPunish;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getCid() {
        return cid;
    }

    public void setCid(Long cid) {
        this.cid = cid;
    }

    public Long getJudgeStaffInfoId() {
        return judgeStaffInfoId;
    }

    public void setJudgeStaffInfoId(Long judgeStaffInfoId) {
        this.judgeStaffInfoId = judgeStaffInfoId;
    }

    public String getJudgeStaffName() {
        return judgeStaffName;
    }

    public void setJudgeStaffName(String judgeStaffName) {
        this.judgeStaffName = judgeStaffName == null ? null : judgeStaffName.trim();
    }

    public Byte getJudgeStatus() {
        return judgeStatus;
    }

    public void setJudgeStatus(Byte judgeStatus) {
        this.judgeStatus = judgeStatus;
    }

    public Byte getResultLevel() {
        return resultLevel;
    }

    public void setResultLevel(Byte resultLevel) {
        this.resultLevel = resultLevel;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Long getCreateBy() {
        return createBy;
    }

    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    public Date getUpdateDate() {
        return updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public Long getUpdateBy() {
        return updateBy;
    }

    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public Boolean getIsValid() {
        return isValid;
    }

    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    public Byte getManagerialSystem() {
        return managerialSystem;
    }

    public void setManagerialSystem(Byte managerialSystem) {
        this.managerialSystem = managerialSystem;
    }

    public Byte getManagerialOrg() {
        return managerialOrg;
    }

    public void setManagerialOrg(Byte managerialOrg) {
        this.managerialOrg = managerialOrg;
    }

    public Byte getManagerialStaff() {
        return managerialStaff;
    }

    public void setManagerialStaff(Byte managerialStaff) {
        this.managerialStaff = managerialStaff;
    }

    public Byte getHarmfulCheck() {
        return harmfulCheck;
    }

    public void setHarmfulCheck(Byte harmfulCheck) {
        this.harmfulCheck = harmfulCheck;
    }

    public Byte getSituationEvaluation() {
        return situationEvaluation;
    }

    public void setSituationEvaluation(Byte situationEvaluation) {
        this.situationEvaluation = situationEvaluation;
    }

    public Byte getOverProofSituation() {
        return overProofSituation;
    }

    public void setOverProofSituation(Byte overProofSituation) {
        this.overProofSituation = overProofSituation;
    }

    public Byte getLocationSetup() {
        return locationSetup;
    }

    public void setLocationSetup(Byte locationSetup) {
        this.locationSetup = locationSetup;
    }

    public Byte getProperRedistribution() {
        return properRedistribution;
    }

    public void setProperRedistribution(Byte properRedistribution) {
        this.properRedistribution = properRedistribution;
    }

    public Byte getCaution() {
        return caution;
    }

    public void setCaution(Byte caution) {
        this.caution = caution;
    }

    public Byte getProjectApplication() {
        return projectApplication;
    }

    public void setProjectApplication(Byte projectApplication) {
        this.projectApplication = projectApplication;
    }

    public Byte getThreeSameTime() {
        return threeSameTime;
    }

    public void setThreeSameTime(Byte threeSameTime) {
        this.threeSameTime = threeSameTime;
    }

    public Byte getContractImpart() {
        return contractImpart;
    }

    public void setContractImpart(Byte contractImpart) {
        this.contractImpart = contractImpart;
    }

    public Byte getFacilitiesEffective() {
        return facilitiesEffective;
    }

    public void setFacilitiesEffective(Byte facilitiesEffective) {
        this.facilitiesEffective = facilitiesEffective;
    }

    public Byte getProtectionArticle() {
        return protectionArticle;
    }

    public void setProtectionArticle(Byte protectionArticle) {
        this.protectionArticle = protectionArticle;
    }

    public Byte getUsingManagement() {
        return usingManagement;
    }

    public void setUsingManagement(Byte usingManagement) {
        this.usingManagement = usingManagement;
    }

    public Byte getPrincipalTraining() {
        return principalTraining;
    }

    public void setPrincipalTraining(Byte principalTraining) {
        this.principalTraining = principalTraining;
    }

    public Byte getWorkerTraining() {
        return workerTraining;
    }

    public void setWorkerTraining(Byte workerTraining) {
        this.workerTraining = workerTraining;
    }

    public Byte getUpOffGuardPhysicalExam() {
        return upOffGuardPhysicalExam;
    }

    public void setUpOffGuardPhysicalExam(Byte upOffGuardPhysicalExam) {
        this.upOffGuardPhysicalExam = upOffGuardPhysicalExam;
    }

    public Byte getOnGuardPhysicalExam() {
        return onGuardPhysicalExam;
    }

    public void setOnGuardPhysicalExam(Byte onGuardPhysicalExam) {
        this.onGuardPhysicalExam = onGuardPhysicalExam;
    }

    public Byte getWardshipRecord() {
        return wardshipRecord;
    }

    public void setWardshipRecord(Byte wardshipRecord) {
        this.wardshipRecord = wardshipRecord;
    }

    public Byte getOccupationalDisease() {
        return occupationalDisease;
    }

    public void setOccupationalDisease(Byte occupationalDisease) {
        this.occupationalDisease = occupationalDisease;
    }

    public Byte getGovPunish() {
        return govPunish;
    }

    public void setGovPunish(Byte govPunish) {
        this.govPunish = govPunish;
    }
}