package cn.smarthse.modules.health.entity.base.selfjudge;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import lombok.Data;

/**
 * company_hse_risk_assessment
 * @author 
 */
@Table(name="company_hse_risk_assessment")
@Data
public class CompanyHseRiskAssessment implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 用人单位职业病危害暴露情况调查和风险评估表-主表id
     */
    @Column(name = "info_id")
    private Long infoId;

    /**
     * 一般职业病危害因素-风险等级 1:低风险2:中风险3:高风险
     */
    @Column(name = "general_over_risk_level")
    private Long generalOverRiskLevel;

    /**
     * 一般职业病危害因素-风险等级 1:低风险2:中风险3:高风险
     */
    @Column(name = "general_not_over_risk_level")
    private Long generalNotOverRiskLevel;

    /**
     * 严重职业病危害因素-风险等级 1:低风险2:中风险3:高风险
     */
    @Column(name = "serious_over_risk_level")
    private Long seriousOverRiskLevel;

    /**
     * 严重职业病危害因素-风险等级 1:低风险2:中风险3:高风险
     */
    @Column(name = "serious_not_over_risk_level")
    private Long seriousNotOverRiskLevel;


    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建者
     */
    @Column(name = "create_by")
    private Long createBy;


    /**
     * 最后修改者
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    private static final long serialVersionUID = 1L;
}