package cn.smarthse.modules.health.entity.base.selfjudge;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * company_hse_prevention_control_self_judge
 * @author 
 */
@Table(name="company_hse_prevention_control_self_judge")
@Data
public class CompanyHsePreventionControlSelfJudge implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * cid
     */
    private Long cid;


    /**
     * 唯一键
     */
    @Column(name = "cid_year")
    private String cidYear;

    /**
     * 企业名称
     */
    @Column(name = "company_name")
    private String companyName;

    /**
     * 自查人(评估人员)
     */
    @Column(name = "self_staff_name")
    private String selfStaffName;

    /**
     * 自查时间(评估时间)
     */
    @Column(name = "self_time")
    private Date selfTime;

    /**
     * 机构id
     */
    @Column(name = "third_org_id")
    private Long thirdOrgId;

    /**
     * 机构名称(冗余)
     */
    @Column(name = "third_org_name")
    private String thirdOrgName;

    /**
     * 状态,1:存草稿 2:完成(待审核) 3:退回(被退回待提交)  4:审核完成(待报送) 5:已报送
     */
    private Byte status;

    /**
     * 在岗职工人数是否大于100,1:小于等于100 2:大于100
     */
    @Column(name = "staff_count_is_gt_hundred")
    private Byte staffCountIsGtHundred;

    /**
     * 数据来源,1:企业端 2:机构端
     */
    @Column(name = "data_source")
    private Byte dataSource;

    /**
     * 评定结果等级,0:未评定 1:A级 2:B级 3:C级
     */
    @Column(name = "judge_level")
    private Long judgeLevel;
    @Column(name = "real_level")
    private Long realLevel;


    @Column(name = "total_score")
    private String totalScore;

    /**
     * 年份
     */
    private Long year;
    /**
     * 自查来自年份还是变更 1：年份 2：变更
     */
    @Column(name = "self_from_year")
    private Byte selfFromYear;

    @Transient
    private List<OccupationalSelfJudgeTermV308> terms;

    /**
     * 上报人
     */
    @Column(name = "report_staff")
    private String reportStaff;

    /**
     * 退回原因
     */
    @Column(name = "back_reason_detail")
    private String backReasonDetail;


    /**
     * 上报时间（完成时间）
     */
    @Column(name = "report_date")
    private Date reportDate;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建者
     */
    @Column(name = "create_by")
    private Long createBy;


    /**
     * 最后修改者
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;


    /**
     * 报告签字人
     */
    @Column(name = "report_sign_staff")
    private String reportSignStaff;

    @Transient
    private String registrant;

    @Column(name = "phone_number")
    private String phoneNumber;

    @Transient
    private Boolean isFirst=false;


    @Column(name = "source_id")
    private Long sourceId;

    /**
     * 标记类型，0原表，1副本表，2退回上报之后的历史数据表(退回时用)
     */
    @Column(name = "table_flag")
    private Byte tableFlag;

    private static final long serialVersionUID = 1L;


}