package cn.smarthse.modules.health.entity.base.selfjudge;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import lombok.Data;

/**
 * company_hse_investigation_risk_assessment_info
 * @author 
 */
@Table(name="company_hse_investigation_risk_assessment_info")
@Data
public class CompanyHseInvestigationRiskAssessmentInfo implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * cid
     */
    private Long cid;

    /**
     * 企业名称
     */
    @Column(name = "company_name")
    private String companyName;

    /**
     * 自查人
     */
    @Column(name = "self_staff_name")
    private String selfStaffName;

    /**
     * 自查时间
     */
    @Column(name = "self_time")
    private Date selfTime;

    /**
     * 机构id
     */
    @Column(name = "third_org_id")
    private Long thirdOrgId;

    /**
     * 机构名称(冗余)
     */
    @Column(name = "third_org_name")
    private String thirdOrgName;

    /**
     * 状态,1:存草稿 2:完成 3:退回
     */
    private Byte status;

    /**
     * 数据来源,1:企业端 2:机构端
     */
    @Column(name = "data_source")
    private Byte dataSource;

    /**
     * 上报人
     */
    @Column(name = "report_staff")
    private String reportStaff;

    /**
     * 上报时间（完成时间）
     */
    @Column(name = "report_date")
    private Date reportDate;

    /**
     * 职业病危害暴露风险等级(风险判定结论) 1:低风险2:中风险3:高风险
     */
    @Column(name = "risk_level")
    private Long riskLevel;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建者
     */
    @Column(name = "create_by")
    private Long createBy;


    /**
     * 最后修改者
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    private static final long serialVersionUID = 1L;
}