package cn.smarthse.modules.health.entity.base.selfjudge;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import lombok.Data;

/**
 * company_hse_investigation
 * @author 
 */
@Table(name="company_hse_investigation")
@Data
public class CompanyHseInvestigation implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 用人单位职业病危害暴露情况调查和风险评估表-主表id
     */
    @Column(name = "info_id")
    private Long infoId;

    /**
     * 岗位/工种
     */
    @Column(name = "work_name")
    private String workName;

    /**
     * 定员
     */
    @Column(name = "staff_count")
    private Long staffCount;

    /**
     * 采样点
     */
    @Column(name = "sampling_point")
    private String samplingPoint;

    /**
     * 职业病危害因素id
     */
    @Column(name = "harm_id")
    private Long harmId;

    /**
     * 职业病危害因素名称
     */
    @Column(name = "harm_name")
    private String harmName;

    /**
     * CTWA
     */
    private String ctwa;

    /**
     * CSTE
     */
    private String cste;

    /**
     * CME
     */
    private String cme;

    /**
     * PE
     */
    private String pe;

    /**
     * 噪声等效声级
     */
    @Column(name = "noise_level")
    private String noiseLevel;

    /**
     * 其他因素浓度/强度
     */
    @Column(name = "other_harm_strong_level")
    private String otherHarmStrongLevel;

    /**
     * 接触水平(1 超标 2不超标)
     */
    @Column(name = "touch_level")
    private Long touchLevel;

    /**
     * 职业病危害因素性质（1一般 2严重）
     */
    @Column(name = "harm_nature")
    private Long harmNature;

    /**
     * 职业病危害暴露风险等级(风险判定结论) 1:低风险2:中风险3:高风险
     */
    @Column(name = "risk_level")
    private Long riskLevel;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建者
     */
    @Column(name = "create_by")
    private Long createBy;


    /**
     * 最后修改者
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    private static final long serialVersionUID = 1L;
}