package cn.smarthse.modules.health.entity.base.selfjudge;


import lombok.Data;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 分类自查修改记录表 (添加删除实体类的时候要修改CompanyGradeV3_Mapper中的插入sql)
 * </p>
 *
 * @author zhangxu
 * @since 2023-02-06
 */
@Data
@Table(name ="classify_self_examination_record")
public class ClassifySelfExaminationRecord implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业id
     */
    private Long cid;

    /**
     * 变更原因
     * (1定期评估 2变更评估（职业病危害接触情况发生重大变化）3变更评估（管理状况发生重大变化)
     *  4变更为健康企业 5取消健康企业)
     */
    private String changeReason;

    /**
     * 变更日期
     */
    private Date changeTime;

    /**
     * 变更类型( 1 是职业病危害风险等级,0:未评定 1:Ⅰ级 2:Ⅱ级 3:Ⅲ级 )
     * 变更类型( 2 是职业卫生管理状况等级,0:未评定 1:A级 2:B级 3:C级 )
     */
    private Integer changeType;

    /**
     * 变更前的数据
     */
    private Integer beforeState;

    /**
     * 变更后的数据
     */
    private Integer afterState;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改时间
     */
    private Date updateTime;

    /**
     * 来源id
     */
    private Long sourceId;

    /**
     * 是否有效（0-无效，1-有效）
     */
    private Boolean isValid;

}
