package cn.smarthse.modules.health.entity.base.occriskfactor;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Table(name = "occupational_risk_factors")
public class OccupationalRiskFactors implements Serializable {
    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    private Long cid;

    private String type;

    @Column(name = "paramCode")
    private String paramcode;

    @Column(name = "name_CH")
    private String nameCh;

    private String alias;

    @Column(name = "CASNo")
    private String casno;

    private String remarks;

    /**
     * 是否高毒物品
     */
    @Column(name = "isHT")
    private Integer isht;

    /**
     * 是否含有呼尘
     */
    @Column(name = "is_has_Respirable_dust")
    private Integer isHasRespirableDust;

    /**
     * 职业健康检查因素
     */
    @Column(name = "occupational_health_id")
    private Integer occupationalHealthId;

    /**
     * 职业禁忌证
     */
    @Column(name = "Occupational_contraindication")
    private String occupationalContraindication;

    /**
     * 职业病 
     */
    @Column(name = "Occupational_disease")
    private String occupationalDisease;

    /**
     * 可能导致职业禁忌证和职业病的依据
     */
    @Column(name = "Basis_Occupational_health")
    private String basisOccupationalHealth;

    /**
     * 推荐的职业病危害警示标识
     */
    @Column(name = "Warning_signs_recommend")
    private String warningSignsRecommend;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 更新时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 更新人
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 更新时间
     */
    @Column(name = "update_date")
    private Date updateDate;


    /**
     * 是否高毒物品
     */
    @Column(name = "belong_gbz22019")
    private Integer belongGbz22019;
  
    private static final long serialVersionUID = 1L;

    /**
     * @return ID
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * @return cid
     */
    public Long getCid() {
        return cid;
    }

    /**
     * @param cid
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * @return type
     */
    public String getType() {
        return type;
    }

    /**
     * @param type
     */
    public void setType(String type) {
        this.type = type == null ? null : type.trim();
    }

    /**
     * @return paramCode
     */
    public String getParamcode() {
        return paramcode;
    }

    /**
     * @param paramcode
     */
    public void setParamcode(String paramcode) {
        this.paramcode = paramcode == null ? null : paramcode.trim();
    }

    /**
     * @return name_CH
     */
    public String getNameCh() {
        return nameCh;
    }

    /**
     * @param nameCh
     */
    public void setNameCh(String nameCh) {
        this.nameCh = nameCh == null ? null : nameCh.trim();
    }

    /**
     * @return alias
     */
    public String getAlias() {
        return alias;
    }

    /**
     * @param alias
     */
    public void setAlias(String alias) {
        this.alias = alias == null ? null : alias.trim();
    }

    /**
     * @return CASNo
     */
    public String getCasno() {
        return casno;
    }

    /**
     * @param casno
     */
    public void setCasno(String casno) {
        this.casno = casno == null ? null : casno.trim();
    }

    /**
     * @return remarks
     */
    public String getRemarks() {
        return remarks;
    }

    /**
     * @param remarks
     */
    public void setRemarks(String remarks) {
        this.remarks = remarks == null ? null : remarks.trim();
    }

    /**
     * 获取是否高毒物品
     *
     * @return isHT - 是否高毒物品
     */
    public Integer getIsht() {
        return isht;
    }

    /**
     * 设置是否高毒物品
     *
     * @param isht 是否高毒物品
     */
    public void setIsht(Integer isht) {
        this.isht = isht;
    }

    /**
     * 获取是否含有呼尘
     *
     * @return is_has_Respirable_dust - 是否含有呼尘
     */
    public Integer getIsHasRespirableDust() {
        return isHasRespirableDust;
    }

    /**
     * 设置是否含有呼尘
     *
     * @param isHasRespirableDust 是否含有呼尘
     */
    public void setIsHasRespirableDust(Integer isHasRespirableDust) {
        this.isHasRespirableDust = isHasRespirableDust;
    }

    /**
     * 获取职业健康检查因素
     *
     * @return occupational_health_id - 职业健康检查因素
     */
    public Integer getOccupationalHealthId() {
        return occupationalHealthId;
    }

    /**
     * 设置职业健康检查因素
     *
     * @param occupationalHealthId 职业健康检查因素
     */
    public void setOccupationalHealthId(Integer occupationalHealthId) {
        this.occupationalHealthId = occupationalHealthId;
    }

    /**
     * 获取职业禁忌证
     *
     * @return Occupational_contraindication - 职业禁忌证
     */
    public String getOccupationalContraindication() {
        return occupationalContraindication;
    }

    /**
     * 设置职业禁忌证
     *
     * @param occupationalContraindication 职业禁忌证
     */
    public void setOccupationalContraindication(String occupationalContraindication) {
        this.occupationalContraindication = occupationalContraindication == null ? null : occupationalContraindication.trim();
    }

    /**
     * 获取职业病 
     *
     * @return Occupational_disease - 职业病 
     */
    public String getOccupationalDisease() {
        return occupationalDisease;
    }

    /**
     * 设置职业病 
     *
     * @param occupationalDisease 职业病 
     */
    public void setOccupationalDisease(String occupationalDisease) {
        this.occupationalDisease = occupationalDisease == null ? null : occupationalDisease.trim();
    }

    /**
     * 获取可能导致职业禁忌证和职业病的依据
     *
     * @return Basis_Occupational_health - 可能导致职业禁忌证和职业病的依据
     */
    public String getBasisOccupationalHealth() {
        return basisOccupationalHealth;
    }

    /**
     * 设置可能导致职业禁忌证和职业病的依据
     *
     * @param basisOccupationalHealth 可能导致职业禁忌证和职业病的依据
     */
    public void setBasisOccupationalHealth(String basisOccupationalHealth) {
        this.basisOccupationalHealth = basisOccupationalHealth == null ? null : basisOccupationalHealth.trim();
    }

    /**
     * 获取推荐的职业病危害警示标识
     *
     * @return Warning_signs_recommend - 推荐的职业病危害警示标识
     */
    public String getWarningSignsRecommend() {
        return warningSignsRecommend;
    }

    /**
     * 设置推荐的职业病危害警示标识
     *
     * @param warningSignsRecommend 推荐的职业病危害警示标识
     */
    public void setWarningSignsRecommend(String warningSignsRecommend) {
        this.warningSignsRecommend = warningSignsRecommend == null ? null : warningSignsRecommend.trim();
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取更新时间
     *
     * @return create_date - 更新时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置更新时间
     *
     * @param createDate 更新时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取更新人
     *
     * @return update_by - 更新人
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置更新人
     *
     * @param updateBy 更新人
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取更新时间
     *
     * @return update_date - 更新时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置更新时间
     *
     * @param updateDate 更新时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public Integer getBelongGbz22019() {
        return belongGbz22019;
    }

    public void setBelongGbz22019(Integer belongGbz22019) {
        this.belongGbz22019 = belongGbz22019;
    }
}