package cn.smarthse.modules.health.entity.base.ms;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 
 * 《NoticeUpdateReminder》
 * 
 * 工作更新提醒
 * @Project:  smarthse-facade
 * @Module ID:   <4.5.2>
 * @Comments:  <管理制度>
 * @JDK version used:      <JDK1.8>
 * @author xiaoyi
 * @since 2021-4-22-下午5:09:10
 */
@Table(name = "notice_update_reminder")
public @Data class NoticeUpdateReminder implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 人员id
     */
    @Column(name = "staff_id")
    private Long staffId;
    /**
     * 更新工作类型(1-规章制度2-操作规程3-应急预案4-其他公告5-职业病危害因素检测)
     */
    @Column(name = "work_type")
    private Byte workType;
    /**
     * 更新项目id
     */
    @Column(name = "work_id")
    private Long workId;
    /**
     * 状态(0-未读1-已读)
     */
    @Column(name = "status")
    private Byte status;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;


}