package cn.smarthse.modules.health.entity.base.ms;

import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 
 * 《MsPohop》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <4.5.4>
 * @Comments:  <操作规程>
 * @JDK version used:      <JDK1.7> 
 * @author 徐颖东 [xyd.900919@qq.com]
 * @since 2017-6-8-下午5:09:10
 */
@Table(name = "ms_pohop")
public @Data class MsPohop implements Serializable {
	
	@Transient
	private String fileIdsStr;
	
	@Transient
	private Long[] fileIds;
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 名称
     */
    @Column(name = "pohop_name")
    private String pohopName;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;
    
    /**
     * 附件id
     */
    @Transient
    private Long fileId;
    
    /**
     * 附件名
     */
    @Transient
    private String fileName;
    
    /**
     * 更新人名称
     */
    @Transient
    private String staffName;
    
    @Transient
    private List<MsPohopUploadFile>   files;
    @Transient
    private List<SysFileModel> fileList;
    /**
     * 更新阅读状态（0：未读，1已读）
     */
    @Transient
    private Integer readState;

    /**
     * 更新时间格式化
     */
    @Transient
    private String updateDateStr;

    /**
     * 附件ID 和 附件名称对应
     *      fileId : fileName
     */
    @Transient
    private Map<Long, String> fileMap = new HashMap<Long, String>();

}