package cn.smarthse.modules.health.entity.base.ms;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;


/**
 * 《职业卫生其他管理文件表》
 * 
 * 
 * @Project:  smarthse-entity
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author XiaoYi（肖奕)
 * @since 2018年7月19日-下午5:37:41
 */
@Table(name = "ms_other")
public @Data class MsOther implements Serializable {
    /**
     * ID
     */
	@Id
	@Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 管理文件名称
     */
    @Column(name = "info_name")
    private String infoName;
    
    /**
     *附件id
     */
    @Column(name = "file_id")
    private String fileId;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;
    
    /**
     * 更新人姓名
     */
    @Transient
    private String updateName;
    /**
     * 附件名
     */
    @Transient
    private String fileName;

	/**
	 * 更新阅读状态（0：未读，1已读）
	 */
	@Transient
	private Integer readState;
    private static final long serialVersionUID = 1L;

    /**
     * 更新时间格式化
     */
    @Transient
    private String updateDateStr;

    /**
     * 附件ID 和 附件名称对应
     *      fileId : fileName
     */
    @Transient
    private Map<Long, String> fileMap = new HashMap<Long, String>();
  
}