package cn.smarthse.modules.health.entity.base.ms;

import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 
 * 《MsInfoUploadFile》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <4.5.2>
 * @Comments:  <管理制度上传文件>
 * @JDK version used:      <JDK1.7> 
 * @author 徐颖东 [xyd.900919@qq.com]
 * @since 2017-6-8-下午5:09:10
 */
@Table(name = "ms_info_upload_file")
public @Data class MsInfoUploadFile implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 管理制度id
     */
    @Column(name = "info_id")
    private Long infoId;

    /**
     * 附件id
     */
    @Column(name = "file_id")
    private Long fileId;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;
    
    @Transient
    private SysFileModel file;

    private static final long serialVersionUID = 1L;
}