package cn.smarthse.modules.health.entity.base.ms;

import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 
 * 《MsInfo》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <4.5.2>
 * @Comments:  <管理制度>
 * @JDK version used:      <JDK1.7> 
 * @author 徐颖东 [xyd.900919@qq.com]
 * @since 2017-6-8-下午5:09:10
 */
@Table(name = "ms_info")
public @Data class MsInfo implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 制度名称
     */
    @Column(name = "info_name")
    private String infoName;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;
    
    /**
     * 附件id
     */
    @Transient
    private List<Long> fileIds;
    
    /**
     * 附件名
     */
    @Transient
    private List<String> fileNames;
    
    /**
     * 更新人
     */
    @Transient
    private String staffName;
    
    @Transient
    private List<MsInfoUploadFile> files;

    @Transient
    private List<SysFileModel> fileList;
    
    @Transient
    private String fileIdStrs;
    /**
     * 更新阅读状态（0：未读，1已读）
     */
    @Transient
    private Integer readState;

    /**
     * 更新时间格式化
     */
    @Transient
    private String updateDateStr;

    /**
     * 附件ID 和 附件名称对应
     *      fileId : fileName
     */
    @Transient
    private Map<Long, String> fileMap = new HashMap<Long, String>();

    /**
     * 已上传文件的制度数
     */
    @Transient
    private Integer uploadCount;
}