package cn.smarthse.modules.health.entity.base.material.vo;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author Zhoucl
 * @date 2021/12/8 13:50
 */
@Data
public class PmcMaterialVo {

    private Long id;

    /**
     * 职业病危害因素ids
     **/
    private String harmFactorIds;
    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 产品物料ID
     */
    private Long materialId;

    /**
     * 物料类别
     */
    private String materialType;

    /**
     * 物料名称
     */
    private String materialName;

    /**
     * 中文别名
     */
    private String materialNick;

    /**
     * 英文名称
     */
    private String materialEname;

    /**
     * CAS号
     */
    private String casNo;

    /**
     * 规格
     */
    private String specification;

    /**
     * 物料状态(枚举 1.气态 2.固态 3.液态 4.其他)
     */
    private Byte materialState;

    /**
     * 计量单位(枚举
     * 1.万吨 2.吨 3.千克 4.克 5.毫克
     * 6.千米 7.米 8.分米9.厘米 10.毫米
     * 11.平方千米 12.平方米 13.平方厘米
     * 14.万立方米 15.立方米16.升
     * 17.个 18.件19.套 20.瓶 21.桶 22.盒 23.箱 24.台}
     */
    private Byte materialUnit;

    /**
     * 是否危险化学品
     */
    private Boolean isHazard;

    /**
     * 是否产生职业病危害因素
     */
    private Boolean isHarm;

    /**
     * 创建时间
     */
    private Date createDate;

    /**
     * 最后修改时间
     */
    private Date updateDate;

    /**
     * 创建人
     */
    private Long createBy;

    /**
     * 最后修改人
     */
    private Long updateBy;

    /**
     * 1-正常,0-已删除
     */
    private Boolean isValid;

    //导入的使用总量
    private BigDecimal materialUseAmount;
    //导入的存储总量
    private BigDecimal materialStoreAmount;

    //物料类别名称
    private String materialtypeName;

    //物料形态名称
    private String materialstateName;

    //计量单位名称
    private String materialunitName;

    /**
     * 年产量/年用量
     */
    private BigDecimal consumptionOrOutput;

    /**
     * 数据所属年份
     */
    private Integer dataYear;
}