package cn.smarthse.modules.health.entity.base.material.vo;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.entity.base.material.PmcMaterialUseInfo;
import cn.smarthse.modules.health.enums.material.*;
import lombok.Data;

import javax.persistence.Transient;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 《企业物料列表VO》
 * <li>适用物料管理首页(可以用于视图与条件实体)
 * <li>导出项表头
 *
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @Project: GIIANTECH CORE
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7>
 * @CopyRight CopyRright (c) 2015
 * @since 2016-3-12-上午9:30:46
 */
@Data
public class MatterItemVO implements Serializable {
    private static final long serialVersionUID = -3219375260144297542L;

    //==========基础信息 materialType, materialName, CASNo, Specification, materialNick, materialEname, materialState, materialUnit, isharm, ishazard, createDate============
    //企业物料编号(companymaterialid)
    private Long id;
    //企业ID
    private Long cid;
    //物料类别
    private String materialtype;
    //物料名称
    private String materialname;
    //CAS编号(用它对应系统物料CAS编号,可以跟系统不同)
    private String casno;
    //规格
    private String specification;
    //别名
    private String materialnick;
    //英文名
    private String materialename;
    //形态  
    private String materialstate;
    //计量单位 
    private String materialunit;
    //是否产生职业病危害因素
    private Boolean isharm;
    //危化品
    private Boolean ishazard;
    //创建时间
    private Date createdate;
    //更新时间
    private Date updatedate;

    //===========================使用/存储信息  useorgname, useAddr, workNames, useSum, tp_productionCompany, tp_supplierCompany, storeAddrname, maxStoreSum, =======================
    //使用车间/组织/部门 名称(多个按逗号隔开)
    private String useorgname;
    //使用地点(多个按逗号隔开)
    private String useAddr;
    //岗位
    private String worknames;
    //使用总数
    private BigDecimal usesum;
    //生产单位
    private String productioncompany;
    //供货单位
    private String suppliercompany;
    //存储车间/组织/部门名称
    private String storeaddrname;
    //最大存储量
    private BigDecimal maxstoresum;
    /**
     * V3.1.6.1 简化版————年产量/年用量
     */
    private BigDecimal consumptionOrOutput;

    //===========================  生产信息 produceOrg, produceAddr, produceSum=======================
    //生产车间/组织/部门 名称(多个按逗号隔开)
    private String produceOrgids;
    private String produceorg;
    //生产地点
    private String produceaddr;
    //年产量(汇总)
    private Double producesum;
    //使用状态Sysparamtype.id
    private Long producestate;

    //===========================  EHS相关信息=======================
    //包装类别说明
    private String wrappertype;
    //安全技术说明书(File.id)
    private String safetyfileId;
    //安全技术说明书(File.id)
    private String safetyfile;
    //安全标签(File.id)
    private String sectagfileId;
    //安全标签(File.id)
    private String sectagfile;
    //产品检验报告(File.id)
    private String partnersfileId;
    //产品检验报告(File.id)
    private String partnersfile;
    //其它附件id集合
    private String otherFileId;
    //其它附件名称
    private String otherFile;
    //可能产生的职业病危害因素
    private String harms;
    //可能产生的职业病危害因素(在sql 中已经完成了拼接）
    private String harmNames;

    //物料类别名称
    @Transient
    private String materialtypeName;

    //物料形态名称
    @Transient
    private String materialstateName;

    //计量单位名称
    @Transient
    private String materialunitName;

    //产品类别名称
    @Transient
    private String productTypeName;

    //包装类别名称
    @Transient
    private String wrappertypeName;

    //使用信息
    @Transient
    private List<PmcMaterialUseInfo> useList;

    //危化品
    @Transient
    private String harm;

    //数据年份
    @Transient
    private String years;

    //当年最后更新时间
    @Transient
    private String lastUpdate;

    public String getHarm() {
        this.setHarm();
        return harm;
    }

    private void setHarm() {
        if (isharm != null) {
            if (isharm == true) {
                this.harm = "是";
            } else {
                this.harm = "否";
            }
        }
    }

    public void setWrappertypeName() {
        if (StringUtils.isInteger(this.wrappertype)) {
            this.wrappertypeName = EhsWrapperTypeEnum.getName(Integer.valueOf(this.wrappertype));
    		/*
	    	if(this.wrappertype.equals("1") || this.wrappertype.equals("2")){
	    		this.wrappertypeName = MaterialTypeEnum.getName(Integer.valueOf(this.wrappertype));
	    	}else{
	    		this.wrappertypeName = ProductTypeEnum.getName(Integer.valueOf(this.wrappertype));
	    	}
	    	*/
        }
    }

    public String getWrappertypeName() {
        this.setWrappertypeName();
        return this.wrappertypeName;
    }

    private void setProductTypeName() {
        if (StringUtils.isInteger(this.materialtype)) {
            this.productTypeName = ProductTypeEnum.getName(Integer.valueOf(this.materialtype));
        }
    }

    public String getProductTypeName() {
        this.setProductTypeName();
        return this.productTypeName;
    }

    private void setMaterialtypeName() {
        if (StringUtils.isInteger(this.materialtype)) {
            this.materialtypeName = MaterialTypeIsZjProjEnum.getName(Integer.valueOf(this.materialtype));
        }
    }

    public String getMaterialtypeName() {
        this.setMaterialtypeName();
        return this.materialtypeName;
    }

    private void setMaterialstateName() {
        if (StringUtils.isInteger(this.materialstate)) {
            this.materialstateName = ShapeStateEnum.getName(Integer.valueOf(this.materialstate));
        }
    }

    public String getMaterialstateName() {
        this.setMaterialstateName();
        return this.materialstateName;
    }

    private void setMaterialunitName() {
        if (StringUtils.isInteger(this.materialunit)) {
            this.materialunitName = UnitOfMeasurementEnum.getName(Integer.valueOf(this.materialunit));
        }
    }

    public String getMaterialunitName() {
        this.setMaterialunitName();
        return this.materialunitName;
    }
}
