package cn.smarthse.modules.health.entity.base.material;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Table(name = "pmc_material_workrole")
public class PmcMaterialWorkrole implements Serializable {
    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 企业物料信息id
     */
    @Column(name = "company_material_id")
    private Long companyMaterialId;

    /**
     * 岗位ID
     */
    @Column(name = "workrole_id")
    private Long workroleId;

    /**
     * 企业物料使用信息ID
     */
    @Column(name = "material_usage_id")
    private Long materialUsageId;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;
    
    /**
     * 1-正常,0-已删除
     */
    @Column(name = "is_valid")
    private Boolean isValid;
    
    /**
     * 岗位名称
     */
    @Transient
    private String workName;

    private static final long serialVersionUID = 1L;
    
    
    

    public String getWorkName() {
		return workName;
	}

	public void setWorkName(String workName) {
		this.workName = workName;
	}

	/**
     * @return ID
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取企业物料信息id
     *
     * @return company_material_id - 企业物料信息id
     */
    public Long getCompanyMaterialId() {
        return companyMaterialId;
    }

    /**
     * 设置企业物料信息id
     *
     * @param companyMaterialId 企业物料信息id
     */
    public void setCompanyMaterialId(Long companyMaterialId) {
        this.companyMaterialId = companyMaterialId;
    }

    /**
     * 获取岗位ID
     *
     * @return workrole_id - 岗位ID
     */
    public Long getWorkroleId() {
        return workroleId;
    }

    /**
     * 设置岗位ID
     *
     * @param workroleId 岗位ID
     */
    public void setWorkroleId(Long workroleId) {
        this.workroleId = workroleId;
    }

    /**
     * 获取企业物料使用信息ID
     *
     * @return material_usage_id - 企业物料使用信息ID
     */
    public Long getMaterialUsageId() {
        return materialUsageId;
    }

    /**
     * 设置企业物料使用信息ID
     *
     * @param materialUsageId 企业物料使用信息ID
     */
    public void setMaterialUsageId(Long materialUsageId) {
        this.materialUsageId = materialUsageId;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人
     *
     * @return update_by - 最后修改人
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人
     *
     * @param updateBy 最后修改人
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

	public Boolean getIsValid() {
		return isValid;
	}

	public void setIsValid(Boolean isValid) {
		this.isValid = isValid;
	}
    
    
}