package cn.smarthse.modules.health.entity.base.material;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

@Table(name = "pmc_material_use_info_area")
public class PmcMaterialUseInfoArea implements Serializable {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 使用信息ID
     */
    @Column(name = "use_info_id")
    private Long useInfoId;

    /**
     * 使用地点ID
     */
    @Column(name = "use_area_id")
    private Long useAreaId;

    /**
     * 使用地点名称
     */
    @Column(name = "use_addr")
    private String useAddr;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;

    /**
     * @return id
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取使用信息ID
     *
     * @return use_info_id - 使用信息ID
     */
    public Long getUseInfoId() {
        return useInfoId;
    }

    /**
     * 设置使用信息ID
     *
     * @param useInfoId 使用信息ID
     */
    public void setUseInfoId(Long useInfoId) {
        this.useInfoId = useInfoId;
    }

    /**
     * 获取使用地点ID
     *
     * @return use_area_id - 使用地点ID
     */
    public Long getUseAreaId() {
        return useAreaId;
    }

    /**
     * 设置使用地点ID
     *
     * @param useAreaId 使用地点ID
     */
    public void setUseAreaId(Long useAreaId) {
        this.useAreaId = useAreaId;
    }

    /**
     * 获取使用地点名称
     *
     * @return use_addr - 使用地点名称
     */
    public String getUseAddr() {
        return useAddr;
    }

    /**
     * 设置使用地点名称
     *
     * @param useAddr 使用地点名称
     */
    public void setUseAddr(String useAddr) {
        this.useAddr = useAddr == null ? null : useAddr.trim();
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }
}