package cn.smarthse.modules.health.entity.base.material;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import cn.smarthse.modules.health.enums.material.UseStateEnum;

@Table(name = "pmc_material_use_info")
public class PmcMaterialUseInfo implements Serializable {
    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 企业物料信息ID
     */
    @Column(name = "company_material_id")
    private Long companyMaterialId;

    /**
     * 使用车间编号
     */
    @Column(name = "useorg_id")
    private Long useorgId;

    /**
     * 使用区域编号
     */
    @Column(name = "use_area_id")
    private Long useAreaId;

    /**
     * 使用地点
     */
    @Column(name = "use_addr")
    private String useAddr;

    /**
     * 生产单位名称
     */
    @Column(name = "tp_production_company")
    private String tpProductionCompany;

    /**
     * 生产单位ID
     */
    @Column(name = "tp_production_company_id")
    private Long tpProductionCompanyId;

    /**
     * 供货单位名称
     */
    @Column(name = "tp_supplier_company")
    private String tpSupplierCompany;

    /**
     * 供货单位ID
     */
    @Column(name = "tp_supplier_company_id")
    private Long tpSupplierCompanyId;

    /**
     * 使用状态(枚举)
     */
    @Column(name = "use_state")
    private Byte useState;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 年使用量
     */
    @Column(name = "usage_year")
    private BigDecimal usageYear;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改人
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 1-正常,0-已删除
     */
    @Column(name = "is_valid")
    private Boolean isValid;
    
    /**
     * 使用车间名称
     */
    @Transient
    private String useAreaName;
    
    /**
     * 使用岗位名称
     */
    @Transient
    private String workNames;
    
    
    /**
     * 使用状态名称
     */
    @Transient
    private String useStateName;
    
    @Transient
    private List<PmcMaterialUseInfoArea> userInfoAreas;
    
    @Transient
    private String userInfoAreaStr;
    
    
    public String getUseStateName(){
    	if(this.useState != null){
    		this.useStateName = UseStateEnum.getName((int)this.useState);
    	}
    	return this.useStateName;
    }
    

    public String getWorkNames() {
		return workNames;
	}

	public void setWorkNames(String workNames) {
		this.workNames = workNames;
	}

	public String getUseAreaName() {
		return useAreaName;
	}

	public void setUseAreaName(String useAreaName) {
		this.useAreaName = useAreaName;
	}

	private static final long serialVersionUID = 1L;

    /**
     * @return ID
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取企业物料信息ID
     *
     * @return company_material_id - 企业物料信息ID
     */
    public Long getCompanyMaterialId() {
        return companyMaterialId;
    }

    /**
     * 设置企业物料信息ID
     *
     * @param companyMaterialId 企业物料信息ID
     */
    public void setCompanyMaterialId(Long companyMaterialId) {
        this.companyMaterialId = companyMaterialId;
    }

    /**
     * 获取使用车间编号
     *
     * @return useorg_id - 使用车间编号
     */
    public Long getUseorgId() {
        return useorgId;
    }

    /**
     * 设置使用车间编号
     *
     * @param useorgId 使用车间编号
     */
    public void setUseorgId(Long useorgId) {
        this.useorgId = useorgId;
    }

    /**
     * 获取使用区域编号
     *
     * @return use_area_id - 使用区域编号
     */
    public Long getUseAreaId() {
        return useAreaId;
    }

    /**
     * 设置使用区域编号
     *
     * @param useAreaId 使用区域编号
     */
    public void setUseAreaId(Long useAreaId) {
        this.useAreaId = useAreaId;
    }

    /**
     * 获取使用地点
     *
     * @return use_addr - 使用地点
     */
    public String getUseAddr() {
        return useAddr;
    }

    /**
     * 设置使用地点
     *
     * @param useAddr 使用地点
     */
    public void setUseAddr(String useAddr) {
        this.useAddr = useAddr == null ? null : useAddr.trim();
    }

    /**
     * 获取生产单位名称
     *
     * @return tp_production_company - 生产单位名称
     */
    public String getTpProductionCompany() {
        return tpProductionCompany;
    }

    /**
     * 设置生产单位名称
     *
     * @param tpProductionCompany 生产单位名称
     */
    public void setTpProductionCompany(String tpProductionCompany) {
        this.tpProductionCompany = tpProductionCompany == null ? null : tpProductionCompany.trim();
    }

    /**
     * 获取生产单位ID
     *
     * @return tp_production_company_id - 生产单位ID
     */
    public Long getTpProductionCompanyId() {
        return tpProductionCompanyId;
    }

    /**
     * 设置生产单位ID
     *
     * @param tpProductionCompanyId 生产单位ID
     */
    public void setTpProductionCompanyId(Long tpProductionCompanyId) {
        this.tpProductionCompanyId = tpProductionCompanyId;
    }

    /**
     * 获取供货单位名称
     *
     * @return tp_supplier_company - 供货单位名称
     */
    public String getTpSupplierCompany() {
        return tpSupplierCompany;
    }

    /**
     * 设置供货单位名称
     *
     * @param tpSupplierCompany 供货单位名称
     */
    public void setTpSupplierCompany(String tpSupplierCompany) {
        this.tpSupplierCompany = tpSupplierCompany == null ? null : tpSupplierCompany.trim();
    }

    /**
     * 获取供货单位ID
     *
     * @return tp_supplier_company_id - 供货单位ID
     */
    public Long getTpSupplierCompanyId() {
        return tpSupplierCompanyId;
    }

    /**
     * 设置供货单位ID
     *
     * @param tpSupplierCompanyId 供货单位ID
     */
    public void setTpSupplierCompanyId(Long tpSupplierCompanyId) {
        this.tpSupplierCompanyId = tpSupplierCompanyId;
    }

    /**
     * 获取使用状态(枚举)
     *
     * @return use_state - 使用状态(枚举)
     */
    public Byte getUseState() {
        return useState;
    }

    /**
     * 设置使用状态(枚举)
     *
     * @param useState 使用状态(枚举)
     */
    public void setUseState(Byte useState) {
        this.useState = useState;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取年使用量
     *
     * @return usage_year - 年使用量
     */
    public BigDecimal getUsageYear() {
        return usageYear;
    }

    /**
     * 设置年使用量
     *
     * @param usageYear 年使用量
     */
    public void setUsageYear(BigDecimal usageYear) {
        this.usageYear = usageYear;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取最后修改人
     *
     * @return update_by - 最后修改人
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人
     *
     * @param updateBy 最后修改人
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取1-正常,0-已删除
     *
     * @return is_valid - 1-正常,0-已删除
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置1-正常,0-已删除
     *
     * @param isValid 1-正常,0-已删除
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }


	public List<PmcMaterialUseInfoArea> getUserInfoAreas() {
		return userInfoAreas;
	}


	public void setUserInfoAreas(List<PmcMaterialUseInfoArea> userInfoAreas) {
		this.userInfoAreas = userInfoAreas;
	}


	public String getUserInfoAreaStr() {
		return userInfoAreaStr;
	}


	public void setUserInfoAreaStr(String userInfoAreaStr) {
		this.userInfoAreaStr = userInfoAreaStr;
	}
    
}