package cn.smarthse.modules.health.entity.base.material;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;

@Table(name = "pmc_material_store_info")
public class PmcMaterialStoreInfo implements Serializable {
    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 企业物料信息id
     */
    @Column(name = "company_material_id")
    private Long companyMaterialId;

    /**
     * 使用区域编号
     */
    @Column(name = "use_area_id")
    private Long useAreaId;

    /**
     * 使用地点
     */
    @Column(name = "use_addr")
    private String useAddr;
    
    /**
     * 使用地点名称
     */
    @Column(name = "use_addr_name")
    private String useAddrName;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最大存储量
     */
    @Column(name = "max_store")
    private BigDecimal maxStore;

    /**
     * 存储容器
     */
    @Column(name = "storage_device")
    private String storageDevice;

    /**
     * 单位
     */
    @Column(name = "material_unit")
    private Long materialUnit;

    /**
     * 是否正常(1-正常,0-删除)
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改人
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    private static final long serialVersionUID = 1L;

    /**
     * @return ID
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取企业物料信息id
     *
     * @return company_material_id - 企业物料信息id
     */
    public Long getCompanyMaterialId() {
        return companyMaterialId;
    }

    /**
     * 设置企业物料信息id
     *
     * @param companyMaterialId 企业物料信息id
     */
    public void setCompanyMaterialId(Long companyMaterialId) {
        this.companyMaterialId = companyMaterialId;
    }

    /**
     * 获取使用区域编号
     *
     * @return use_area_id - 使用区域编号
     */
    public Long getUseAreaId() {
        return useAreaId;
    }

    /**
     * 设置使用区域编号
     *
     * @param useAreaId 使用区域编号
     */
    public void setUseAreaId(Long useAreaId) {
        this.useAreaId = useAreaId;
    }

    /**
     * 获取使用地点
     *
     * @return use_addr - 使用地点
     */
    public String getUseAddr() {
        return useAddr;
    }

    /**
     * 设置使用地点
     *
     * @param useAddr 使用地点
     */
    public void setUseAddr(String useAddr) {
        this.useAddr = useAddr == null ? null : useAddr.trim();
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最大存储量
     *
     * @return max_store - 最大存储量
     */
    public BigDecimal getMaxStore() {
        return maxStore;
    }

    /**
     * 设置最大存储量
     *
     * @param maxStore 最大存储量
     */
    public void setMaxStore(BigDecimal maxStore) {
        this.maxStore = maxStore;
    }

    /**
     * 获取存储容器
     *
     * @return storage_device - 存储容器
     */
    public String getStorageDevice() {
        return storageDevice;
    }

    /**
     * 设置存储容器
     *
     * @param storageDevice 存储容器
     */
    public void setStorageDevice(String storageDevice) {
        this.storageDevice = storageDevice == null ? null : storageDevice.trim();
    }

    /**
     * 获取单位
     *
     * @return material_unit - 单位
     */
    public Long getMaterialUnit() {
        return materialUnit;
    }

    /**
     * 设置单位
     *
     * @param materialUnit 单位
     */
    public void setMaterialUnit(Long materialUnit) {
        this.materialUnit = materialUnit;
    }

    /**
     * 获取是否正常(1-正常,0-删除)
     *
     * @return is_valid - 是否正常(1-正常,0-删除)
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否正常(1-正常,0-删除)
     *
     * @param isValid 是否正常(1-正常,0-删除)
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取最后修改人
     *
     * @return update_by - 最后修改人
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人
     *
     * @param updateBy 最后修改人
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

	public String getUseAddrName() {
		return useAddrName;
	}

	public void setUseAddrName(String useAddrName) {
		this.useAddrName = useAddrName;
	}
    
    
}