package cn.smarthse.modules.health.entity.base.material;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;

import cn.smarthse.modules.health.enums.material.ProduceStateEnum;

@Table(name = "pmc_material_produce_info")
public class PmcMaterialProduceInfo implements Serializable {
    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 企业物料信息id
     */
    @Column(name = "company_material_id")
    private Long companyMaterialId;

    /**
     * 生产车间编号
     */
    @Column(name = "produce_orgid")
    private Long produceOrgid;

    /**
     * 使用区域编号
     */
    @Column(name = "produce_area_id")
    private Long produceAreaId;

    /**
     * 生产地点
     */
    @Column(name = "produce_addr")
    private String produceAddr;

    /**
     * 使用状态Sysparamtype.id
     */
    @Column(name = "produce_state")
    private Integer produceState;

    /**
     * 生产量
     */
    @Column(name = "produce_count")
    private BigDecimal produceCount;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 1-正常,0-已删除
     */
    @Column(name = "is_valid")
    private Boolean isValid;
    
    /**
     * 生产车间名称
     */
    @Transient
    private String produceOrgName;
    
    /**
     * 生产状态名称
     */
    @Transient
    private String produceStateName;
    
    
    /**
     * 排序
     */
    @Transient
    private String order;
    
    
    
    
    
    public String getOrder() {
		return order;
	}

	public void setOrder(String order) {
		this.order = order;
	}

	public String getProduceStateName() {
    	this.setProduceStateName();
		return produceStateName;
	}

	private void setProduceStateName() {
		this.produceStateName = ProduceStateEnum.getName(this.produceState);
	}

	public String getProduceOrgName() {
		return produceOrgName;
	}

	public void setProduceOrgName(String produceOrgName) {
		this.produceOrgName = produceOrgName;
	}

	private static final long serialVersionUID = 1L;

    /**
     * @return ID
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取企业物料信息id
     *
     * @return company_material_id - 企业物料信息id
     */
    public Long getCompanyMaterialId() {
        return companyMaterialId;
    }

    /**
     * 设置企业物料信息id
     *
     * @param companyMaterialId 企业物料信息id
     */
    public void setCompanyMaterialId(Long companyMaterialId) {
        this.companyMaterialId = companyMaterialId;
    }

    /**
     * 获取生产车间编号
     *
     * @return produce_orgid - 生产车间编号
     */
    public Long getProduceOrgid() {
        return produceOrgid;
    }

    /**
     * 设置生产车间编号
     *
     * @param produceOrgid 生产车间编号
     */
    public void setProduceOrgid(Long produceOrgid) {
        this.produceOrgid = produceOrgid;
    }

    /**
     * 获取使用区域编号
     *
     * @return produce_area_id - 使用区域编号
     */
    public Long getProduceAreaId() {
        return produceAreaId;
    }

    /**
     * 设置使用区域编号
     *
     * @param produceAreaId 使用区域编号
     */
    public void setProduceAreaId(Long produceAreaId) {
        this.produceAreaId = produceAreaId;
    }

    /**
     * 获取生产地点
     *
     * @return produce_addr - 生产地点
     */
    public String getProduceAddr() {
        return produceAddr;
    }

    /**
     * 设置生产地点
     *
     * @param produceAddr 生产地点
     */
    public void setProduceAddr(String produceAddr) {
        this.produceAddr = produceAddr == null ? null : produceAddr.trim();
    }

    /**
     * 获取使用状态Sysparamtype.id
     *
     * @return produce_state - 使用状态Sysparamtype.id
     */
    public Integer getProduceState() {
        return produceState;
    }

    /**
     * 设置使用状态Sysparamtype.id
     *
     * @param produceState 使用状态Sysparamtype.id
     */
    public void setProduceState(Integer produceState) {
        this.produceState = produceState;
    }

    /**
     * 获取生产量
     *
     * @return produce_count - 生产量
     */
    public BigDecimal getProduceCount() {
        return produceCount;
    }

    /**
     * 设置生产量
     *
     * @param produceCount 生产量
     */
    public void setProduceCount(BigDecimal produceCount) {
        this.produceCount = produceCount;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人
     *
     * @return update_by - 最后修改人
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人
     *
     * @param updateBy 最后修改人
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取1-正常,0-已删除
     *
     * @return is_valid - 1-正常,0-已删除
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置1-正常,0-已删除
     *
     * @param isValid 1-正常,0-已删除
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }
}